/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.graph_creator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.network.graph_creator.GraphFunction;
import org.h2gis.network.graph_creator.GraphFunctionParser;
import org.h2gis.utilities.TableLocation;
import org.javanetworkanalyzer.data.VUCent;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ST_ConnectedComponents
extends GraphFunction
implements ScalarFunction {
    protected static final int BATCH_SIZE = 100;
    public static final int NULL_CONNECTED_COMPONENT_NUMBER = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("gui." + ST_ConnectedComponents.class));
    public static final String REMARKS = "`ST_ConnectedComponents` calculates the connected components (for undirected\ngraphs) or strongly connected components (for directed graphs) of a graph.  It\nproduces two tables (nodes and edges) containing a node or edge id and a\nconnected component id. Signature: \n* `ST_ConnectedComponents('input_edges', 'o[ - eo]')`\n\nwhere \n* `input_edges` = Edges table produced by `ST_Graph` from table `input`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected).\n";

    public ST_ConnectedComponents() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "getConnectedComponents";
    }

    public static boolean getConnectedComponents(Connection connection, String inputTable, String orientation) throws SQLException {
        TableLocation edgesName;
        KeyedGraph graph = ST_ConnectedComponents.prepareGraph(connection, inputTable, orientation, null, VUCent.class, Edge.class);
        if (graph == null) {
            return false;
        }
        List<Set<VUCent>> componentsList = ST_ConnectedComponents.getConnectedComponents((Graph<VUCent, Edge>)graph, orientation);
        TableLocation tableName = GraphFunctionParser.parseInputTable(connection, inputTable);
        TableLocation nodesName = GraphFunctionParser.suffixTableLocation(tableName, "_NODE_CC");
        return ST_ConnectedComponents.storeNodeConnectedComponents(connection, nodesName, edgesName = GraphFunctionParser.suffixTableLocation(tableName, "_EDGE_CC"), componentsList) && ST_ConnectedComponents.storeEdgeConnectedComponents(connection, tableName, nodesName, edgesName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancel(Connection connection, TableLocation nodesName, TableLocation edgesName, SQLException e, String msg) throws SQLException {
        LOGGER.error(msg, (Throwable)e);
        Statement statement = connection.createStatement();
        try {
            statement.execute("DROP TABLE IF EXISTS " + nodesName);
            statement.execute("DROP TABLE IF EXISTS " + edgesName);
        }
        finally {
            statement.close();
        }
    }

    private static List<Set<VUCent>> getConnectedComponents(Graph<VUCent, Edge> graph, String orientation) {
        LOGGER.info("Calculating connected components... ");
        long start = System.currentTimeMillis();
        List sets = GraphFunctionParser.parseGlobalOrientation(orientation).equals((Object)GraphFunctionParser.Orientation.UNDIRECTED) ? new ConnectivityInspector((UndirectedGraph)graph).connectedSets() : new StrongConnectivityInspector((DirectedGraph)graph).stronglyConnectedSets();
        ST_ConnectedComponents.logTime(LOGGER, start);
        return sets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean storeNodeConnectedComponents(Connection connection, TableLocation nodesName, TableLocation edgesName, List<Set<VUCent>> componentsList) throws SQLException {
        LOGGER.info("Storing node connected components... ");
        long start = System.currentTimeMillis();
        ST_ConnectedComponents.createNodeTable(connection, nodesName);
        PreparedStatement nodeSt = connection.prepareStatement("INSERT INTO " + nodesName + " VALUES(?,?)");
        try {
            boolean previousAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            int componentNumber = 0;
            for (Set<VUCent> component : componentsList) {
                ++componentNumber;
                int count = 0;
                for (VUCent v : component) {
                    nodeSt.setInt(1, v.getID());
                    nodeSt.setInt(2, componentNumber);
                    nodeSt.addBatch();
                    if (++count < 100) continue;
                    nodeSt.executeBatch();
                    nodeSt.clearBatch();
                    count = 0;
                }
                if (count > 0) {
                    nodeSt.executeBatch();
                    nodeSt.clearBatch();
                }
                connection.commit();
            }
            connection.setAutoCommit(previousAutoCommit);
        }
        catch (SQLException e) {
            ST_ConnectedComponents.cancel(connection, nodesName, edgesName, e, "Could not store node connected components.");
            boolean bl = false;
            return bl;
        }
        finally {
            nodeSt.close();
        }
        ST_ConnectedComponents.logTime(LOGGER, start);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNodeTable(Connection connection, TableLocation nodesName) throws SQLException {
        Statement st = connection.createStatement();
        try {
            st.execute("CREATE TABLE " + nodesName + "(" + "NODE_ID" + " INTEGER PRIMARY KEY, " + "CONNECTED_COMPONENT" + " INTEGER);");
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean storeEdgeConnectedComponents(Connection connection, TableLocation tableName, TableLocation nodesName, TableLocation edgesName) throws SQLException {
        LOGGER.info("Storing edge connected components...");
        long start = System.currentTimeMillis();
        Statement st = connection.createStatement();
        try {
            String tmpName = "TMP" + System.currentTimeMillis();
            String startNodeCC = "SN_CC";
            String endNodeCC = "EN_CC";
            st.execute("CREATE INDEX ON " + tableName + "(" + "START_NODE" + ");" + "CREATE INDEX ON " + nodesName + "(" + "NODE_ID" + ");" + "CREATE TEMPORARY TABLE " + tmpName + "(" + "EDGE_ID" + " INT PRIMARY KEY, " + "SN_CC" + " INT, " + "EN_CC" + " INT) " + "AS SELECT A." + "EDGE_ID" + ", B." + "CONNECTED_COMPONENT" + ", NULL " + "FROM " + tableName + " A, " + nodesName + " B " + "WHERE A." + "START_NODE" + "=B." + "NODE_ID" + ";" + "CREATE INDEX ON " + tableName + "(" + "END_NODE" + ");" + "CREATE INDEX ON " + tableName + "(" + "EDGE_ID" + ");" + "CREATE INDEX ON " + tmpName + "(" + "EDGE_ID" + ");" + "UPDATE " + tmpName + " C " + "SET " + "EN_CC" + "=(" + "SELECT B." + "CONNECTED_COMPONENT" + " " + "FROM " + tableName + " A, " + nodesName + " B " + "WHERE A." + "END_NODE" + "=B." + "NODE_ID" + " AND C." + "EDGE_ID" + "=A." + "EDGE_ID" + ");" + "CREATE TABLE " + edgesName + "(" + "EDGE_ID" + " INT PRIMARY KEY, " + "CONNECTED_COMPONENT" + " INT) AS " + "SELECT " + "EDGE_ID" + ", " + "SN_CC" + " " + "FROM " + tmpName + " WHERE " + "SN_CC" + "=" + "EN_CC" + "; " + "INSERT INTO " + edgesName + "(" + "EDGE_ID" + ", " + "CONNECTED_COMPONENT" + ") " + "SELECT " + "EDGE_ID" + ", " + -1 + " FROM " + tmpName + " WHERE " + "SN_CC" + "!=" + "EN_CC" + ";" + "DROP TABLE IF EXISTS " + tmpName + ";");
        }
        catch (SQLException e) {
            ST_ConnectedComponents.cancel(connection, nodesName, edgesName, e, "Could not store edge connected components.");
            boolean bl = false;
            return bl;
        }
        finally {
            st.close();
        }
        ST_ConnectedComponents.logTime(LOGGER, start);
        return true;
    }
}

