/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.network.graph_creator;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.h2.tools.SimpleResultSet;
import org.h2.value.Value;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;
import org.h2gis.h2spatial.TableFunctionUtil;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.network.graph_creator.GraphFunction;
import org.h2gis.network.graph_creator.GraphFunctionParser;
import org.h2gis.network.graph_creator.ST_ShortestPath;
import org.h2gis.utilities.TableLocation;
import org.javanetworkanalyzer.alg.Dijkstra;
import org.javanetworkanalyzer.data.VDijkstra;
import org.javanetworkanalyzer.model.Edge;
import org.javanetworkanalyzer.model.KeyedGraph;
import org.javanetworkanalyzer.model.TraversalGraph;
import org.jgrapht.Graph;

public class ST_ShortestPathTree
extends GraphFunction
implements ScalarFunction {
    public static final String REMARKS = "Calculates the shortest path tree from a given vertex of a\ngraph using Dijkstra's algorithm.\nPossible signatures:\n* `ST_ShortestPathTree('INPUT_EDGES', 'o[ - eo]', s)`\n* `ST_ShortestPathTree('INPUT_EDGES', 'o[ - eo]', s, r)`\n* `ST_ShortestPathTree('INPUT_EDGES', 'o[ - eo]', 'w', s)`\n* `ST_ShortestPathTree('INPUT_EDGES', 'o[ - eo]', 'w', s, r)`\n\nwhere\n* `INPUT_EDGES` = Edges table produced by `ST_Graph` from table `INPUT`\n* `o` = Global orientation (directed, reversed or undirected)\n* `eo` = Edge orientation (1 = directed, -1 = reversed, 0 = undirected).\n   Required if global orientation is directed or reversed.\n* `s` = Source vertex id\n* `r` = Radius by which to limit the search (a `DOUBLE`)\n* `w` = Name of column containing edge weights as `DOUBLES`\n";

    public ST_ShortestPathTree() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "getShortestPathTree";
    }

    public static ResultSet getShortestPathTree(Connection connection, String inputTable, String orientation, int source) throws SQLException {
        return ST_ShortestPathTree.oneToAll(connection, inputTable, orientation, null, source, Double.POSITIVE_INFINITY);
    }

    public static ResultSet getShortestPathTree(Connection connection, String inputTable, String orientation, Value arg4, Value arg5) throws SQLException {
        if (arg4 instanceof ValueInt) {
            int source = arg4.getInt();
            if (arg5 instanceof ValueDecimal) {
                double radius = arg5.getDouble();
                return ST_ShortestPathTree.oneToAll(connection, inputTable, orientation, null, source, radius);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg5);
        }
        if (arg4 instanceof ValueString) {
            String weight = arg4.getString();
            if (arg5 instanceof ValueInt) {
                int source = arg5.getInt();
                return ST_ShortestPathTree.oneToAll(connection, inputTable, orientation, weight, source, Double.POSITIVE_INFINITY);
            }
            throw new IllegalArgumentException("Unrecognized argument: " + arg5);
        }
        throw new IllegalArgumentException("Unrecognized argument: " + arg4);
    }

    public static ResultSet getShortestPathTree(Connection connection, String inputTable, String orientation, String weight, int source, double radius) throws SQLException {
        return ST_ShortestPathTree.oneToAll(connection, inputTable, orientation, weight, source, radius);
    }

    private static ResultSet oneToAll(Connection connection, String inputTable, String orientation, String weight, int source, double radius) throws SQLException {
        TraversalGraph shortestPathTree;
        TableLocation tableName = GraphFunctionParser.parseInputTable(connection, inputTable);
        String firstGeometryField = ST_ShortestPath.getFirstGeometryField(connection, tableName);
        boolean containsGeomField = firstGeometryField != null;
        SimpleResultSet output = ST_ShortestPathTree.prepareResultSet(containsGeomField);
        if (TableFunctionUtil.isColumnListConnection((Connection)connection)) {
            return output;
        }
        KeyedGraph graph = ST_ShortestPathTree.prepareGraph(connection, inputTable, orientation, weight, VDijkstra.class, Edge.class);
        Dijkstra dijkstra = new Dijkstra((Graph)graph);
        VDijkstra vSource = (VDijkstra)graph.getVertex(source);
        if (radius < Double.POSITIVE_INFINITY) {
            dijkstra.calculate(vSource, radius);
            shortestPathTree = dijkstra.reconstructTraversalGraph(radius);
        } else {
            dijkstra.calculate(vSource);
            shortestPathTree = dijkstra.reconstructTraversalGraph();
        }
        if (containsGeomField) {
            Map<Integer, Geometry> edgeGeometryMap = ST_ShortestPath.getEdgeGeometryMap(connection, tableName, firstGeometryField);
            for (Edge e : shortestPathTree.edgeSet()) {
                Edge baseGraphEdge = e.getBaseGraphEdge();
                int id = baseGraphEdge.getID();
                output.addRow(new Object[]{edgeGeometryMap.get(Math.abs(id)), id, ((VDijkstra)shortestPathTree.getEdgeSource((Object)e)).getID(), ((VDijkstra)shortestPathTree.getEdgeTarget((Object)e)).getID(), graph.getEdgeWeight((Object)baseGraphEdge)});
            }
        } else {
            for (Edge e : shortestPathTree.edgeSet()) {
                Edge baseGraphEdge = e.getBaseGraphEdge();
                int id = baseGraphEdge.getID();
                output.addRow(new Object[]{id, ((VDijkstra)shortestPathTree.getEdgeSource((Object)e)).getID(), ((VDijkstra)shortestPathTree.getEdgeTarget((Object)e)).getID(), graph.getEdgeWeight((Object)baseGraphEdge)});
            }
        }
        return output;
    }

    private static SimpleResultSet prepareResultSet(boolean includeGeomColumn) {
        SimpleResultSet output = new SimpleResultSet();
        if (includeGeomColumn) {
            output.addColumn("THE_GEOM", 2000, "GEOMETRY", 0, 0);
        }
        output.addColumn("EDGE_ID", 4, 10, 0);
        output.addColumn("SOURCE", 4, 10, 0);
        output.addColumn("DESTINATION", 4, 10, 0);
        output.addColumn("WEIGHT", 8, 10, 0);
        return output;
    }
}

