/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.affine_transformations;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Scale
extends DeterministicScalarFunction {
    public ST_Scale() {
        this.addProperty("remarks", "Scales the given geometry by multiplying the coordinates by the indicated scale factors");
    }

    public String getJavaStaticMethod() {
        return "scale";
    }

    public static Geometry scale(Geometry geom, double xFactor, double yFactor) {
        return ST_Scale.scale(geom, xFactor, yFactor, 1.0);
    }

    public static Geometry scale(Geometry geom, double xFactor, double yFactor, double zFactor) {
        if (geom != null) {
            Geometry scaledGeom = (Geometry)geom.clone();
            for (Coordinate c : scaledGeom.getCoordinates()) {
                c.setOrdinate(0, c.getOrdinate(0) * xFactor);
                c.setOrdinate(1, c.getOrdinate(1) * yFactor);
                c.setOrdinate(2, c.getOrdinate(2) * zFactor);
            }
            return scaledGeom;
        }
        return null;
    }
}

