/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.convert;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Force2D
extends DeterministicScalarFunction {
    public ST_Force2D() {
        this.addProperty("remarks", "Forces the geometries into a \"2-dimensional mode\" \n so that all output representations will only have the X and Y coordinates.");
    }

    public String getJavaStaticMethod() {
        return "force2D";
    }

    public static Geometry force2D(Geometry geom) {
        if (geom == null) {
            return null;
        }
        Geometry outPut = (Geometry)geom.clone();
        outPut.apply(new CoordinateSequenceFilter(){
            private boolean done = false;

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return this.done;
            }

            public void filter(CoordinateSequence seq, int i) {
                seq.setOrdinate(i, 2, Double.NaN);
                if (i == seq.size()) {
                    this.done = true;
                }
            }
        });
        return outPut;
    }
}

