/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_ToMultiLine
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_ToMultiLine() {
        this.addProperty("remarks", "Constructs a MultiLineString from the given geometry's coordinates.");
    }

    public String getJavaStaticMethod() {
        return "createMultiLineString";
    }

    public static MultiLineString createMultiLineString(Geometry geom) throws SQLException {
        if (geom != null) {
            if (geom.getDimension() > 0) {
                LinkedList<LineString> lineStrings = new LinkedList<LineString>();
                ST_ToMultiLine.toMultiLineString(geom, lineStrings);
                return GEOMETRY_FACTORY.createMultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
            }
            return GEOMETRY_FACTORY.createMultiLineString(null);
        }
        return null;
    }

    private static void toMultiLineString(Geometry geometry, List<LineString> lineStrings) throws SQLException {
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            throw new SQLException("Found a point! Cannot create a MultiLineString.");
        }
        if (geometry instanceof LineString) {
            ST_ToMultiLine.toMultiLineString((LineString)geometry, lineStrings);
        } else if (geometry instanceof Polygon) {
            ST_ToMultiLine.toMultiLineString((Polygon)geometry, lineStrings);
        } else if (geometry instanceof GeometryCollection) {
            ST_ToMultiLine.toMultiLineString((GeometryCollection)geometry, lineStrings);
        }
    }

    private static void toMultiLineString(LineString lineString, List<LineString> lineStrings) {
        lineStrings.add(lineString);
    }

    private static void toMultiLineString(Polygon polygon, List<LineString> lineStrings) {
        lineStrings.add(polygon.getExteriorRing());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            lineStrings.add(polygon.getInteriorRingN(i));
        }
    }

    private static void toMultiLineString(GeometryCollection geometryCollection, List<LineString> lineStrings) throws SQLException {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            ST_ToMultiLine.toMultiLineString(geometryCollection.getGeometryN(i), lineStrings);
        }
    }
}

