/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.create;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_MakeEllipse
extends DeterministicScalarFunction {
    private static final GeometricShapeFactory GSF = new GeometricShapeFactory();

    public ST_MakeEllipse() {
        this.addProperty("remarks", "Constructs an elliptical POLYGON with the given width and height centered at the given point. Each ellipse contains 100 line segments.");
    }

    public String getJavaStaticMethod() {
        return "makeEllipse";
    }

    public static Polygon makeEllipse(Point p, double width, double height) throws SQLException {
        if (p == null) {
            return null;
        }
        if (height < 0.0 || width < 0.0) {
            throw new SQLException("Both width and height must be positive.");
        }
        GSF.setCentre(new Coordinate(p.getX(), p.getY()));
        GSF.setWidth(width);
        GSF.setHeight(height);
        return GSF.createEllipse();
    }
}

