/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.distance;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_ClosestCoordinate
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_ClosestCoordinate() {
        this.addProperty("remarks", "Computes the closest coordinate(s) contained in the given geometry starting from the given point, using the 2D distance.");
    }

    public String getJavaStaticMethod() {
        return "getFurthestCoordinate";
    }

    public static Geometry getFurthestCoordinate(Point point, Geometry geom) {
        if (point == null || geom == null) {
            return null;
        }
        double minDistance = Double.POSITIVE_INFINITY;
        Coordinate pointCoordinate = point.getCoordinate();
        HashSet<Coordinate> closestCoordinates = new HashSet<Coordinate>();
        for (Coordinate c : geom.getCoordinates()) {
            double distance = c.distance(pointCoordinate);
            if (Double.compare(distance, minDistance) == 0) {
                closestCoordinates.add(c);
            }
            if (Double.compare(distance, minDistance) >= 0) continue;
            minDistance = distance;
            closestCoordinates.clear();
            closestCoordinates.add(c);
        }
        if (closestCoordinates.size() == 1) {
            return GEOMETRY_FACTORY.createPoint((Coordinate)closestCoordinates.iterator().next());
        }
        return GEOMETRY_FACTORY.createMultiPoint(closestCoordinates.toArray(new Coordinate[closestCoordinates.size()]));
    }
}

