/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.drivers.utility.CoordinatesUtils;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.h2spatialext.function.spatial.edit.EditUtilities;

public class ST_AddPoint
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();
    public static final double PRECISION = 1.0E-5;

    public ST_AddPoint() {
        this.addProperty("remarks", "Adds a point to a geometry. \nA tolerance could be set to snap the point to the geometry.");
    }

    public String getJavaStaticMethod() {
        return "addPoint";
    }

    public static Geometry addPoint(Geometry geometry, Point point) throws SQLException {
        return ST_AddPoint.addPoint(geometry, point, 1.0E-5);
    }

    public static Geometry addPoint(Geometry geometry, Point point, double tolerance) throws SQLException {
        if (geometry == null || point == null) {
            return null;
        }
        if (geometry instanceof MultiPoint) {
            return ST_AddPoint.insertVertexInMultipoint(geometry, point);
        }
        if (geometry instanceof LineString) {
            return ST_AddPoint.insertVertexInLineString((LineString)geometry, point, tolerance);
        }
        if (geometry instanceof MultiLineString) {
            LineString[] linestrings = new LineString[geometry.getNumGeometries()];
            boolean any = false;
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                LineString line = (LineString)geometry.getGeometryN(i);
                LineString inserted = ST_AddPoint.insertVertexInLineString(line, point, tolerance);
                if (inserted != null) {
                    linestrings[i] = inserted;
                    any = true;
                    continue;
                }
                linestrings[i] = line;
            }
            if (any) {
                return FACTORY.createMultiLineString(linestrings);
            }
            return null;
        }
        if (geometry instanceof Polygon) {
            return ST_AddPoint.insertVertexInPolygon((Polygon)geometry, point, tolerance);
        }
        if (geometry instanceof MultiPolygon) {
            Polygon[] polygons = new Polygon[geometry.getNumGeometries()];
            boolean any = false;
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)geometry.getGeometryN(i);
                Polygon inserted = ST_AddPoint.insertVertexInPolygon(polygon, point, tolerance);
                if (inserted != null) {
                    any = true;
                    polygons[i] = inserted;
                    continue;
                }
                polygons[i] = polygon;
            }
            if (any) {
                return FACTORY.createMultiPolygon(polygons);
            }
            return null;
        }
        if (geometry instanceof Point) {
            return null;
        }
        throw new SQLException("Unknown geometry type : " + geometry.getGeometryType());
    }

    private static Geometry insertVertexInMultipoint(Geometry g, Point vertexPoint) {
        ArrayList<Point> geoms = new ArrayList<Point>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Point geom = (Point)g.getGeometryN(i);
            geoms.add(geom);
        }
        geoms.add(FACTORY.createPoint(new Coordinate(vertexPoint.getX(), vertexPoint.getY())));
        return FACTORY.createMultiPoint(GeometryFactory.toPointArray(geoms));
    }

    private static LineString insertVertexInLineString(LineString lineString, Point vertexPoint, double tolerance) throws SQLException {
        GeometryLocation geomLocation = EditUtilities.getVertexToSnap((Geometry)lineString, vertexPoint, tolerance);
        if (geomLocation != null) {
            Coordinate[] coords = lineString.getCoordinates();
            int index = geomLocation.getSegmentIndex();
            Coordinate coord = geomLocation.getCoordinate();
            if (!CoordinatesUtils.contains2D((Coordinate[])coords, (Coordinate)coord)) {
                Coordinate[] ret = new Coordinate[coords.length + 1];
                System.arraycopy(coords, 0, ret, 0, index + 1);
                ret[index + 1] = coord;
                System.arraycopy(coords, index + 1, ret, index + 2, coords.length - (index + 1));
                return FACTORY.createLineString(ret);
            }
            return null;
        }
        return lineString;
    }

    private static Polygon insertVertexInPolygon(Polygon polygon, Point vertexPoint, double tolerance) throws SQLException {
        Polygon geom = polygon;
        LineString linearRing = polygon.getExteriorRing();
        int index = -1;
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            double distCurr = ST_AddPoint.computeDistance((Geometry)polygon.getInteriorRingN(i), vertexPoint, tolerance);
            if (!(distCurr < tolerance)) continue;
            index = i;
        }
        if (index == -1) {
            LinearRing inserted = ST_AddPoint.insertVertexInLinearRing(linearRing, vertexPoint, tolerance);
            if (inserted != null) {
                LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
                for (int i = 0; i < holes.length; ++i) {
                    holes[i] = (LinearRing)polygon.getInteriorRingN(i);
                }
                geom = FACTORY.createPolygon(inserted, holes);
            }
        } else {
            LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
            for (int i = 0; i < holes.length; ++i) {
                holes[i] = i == index ? ST_AddPoint.insertVertexInLinearRing(polygon.getInteriorRingN(i), vertexPoint, tolerance) : (LinearRing)polygon.getInteriorRingN(i);
            }
            geom = FACTORY.createPolygon((LinearRing)linearRing, holes);
        }
        if (geom != null && !geom.isValid()) {
            throw new SQLException("Geometry not valid");
        }
        return geom;
    }

    private static double computeDistance(Geometry geometry, Point vertexPoint, double tolerance) {
        DistanceOp distanceOp = new DistanceOp(geometry, (Geometry)vertexPoint, tolerance);
        return distanceOp.distance();
    }

    private static LinearRing insertVertexInLinearRing(LineString lineString, Point vertexPoint, double tolerance) {
        GeometryLocation geomLocation = EditUtilities.getVertexToSnap((Geometry)lineString, vertexPoint, tolerance);
        if (geomLocation != null) {
            Coordinate[] coords = lineString.getCoordinates();
            int index = geomLocation.getSegmentIndex();
            Coordinate coord = geomLocation.getCoordinate();
            if (!CoordinatesUtils.contains2D((Coordinate[])coords, (Coordinate)coord)) {
                Coordinate[] ret = new Coordinate[coords.length + 1];
                System.arraycopy(coords, 0, ret, 0, index + 1);
                ret[index + 1] = coord;
                System.arraycopy(coords, index + 1, ret, index + 2, coords.length - (index + 1));
                return FACTORY.createLinearRing(ret);
            }
            return null;
        }
        return null;
    }
}

