/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.edit;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_FlipCoordinates
extends DeterministicScalarFunction {
    public ST_FlipCoordinates() {
        this.addProperty("remarks", "Returns a version of the given geometry with X and Y axis flipped. Useful for people who have built\nlatitude/longitude features and need to fix them.");
    }

    public String getJavaStaticMethod() {
        return "flipCoordinates";
    }

    public static Geometry flipCoordinates(Geometry geom) {
        if (geom != null) {
            geom.apply((CoordinateSequenceFilter)new FlipCoordinateSequenceFilter());
            return geom;
        }
        return null;
    }

    public static class FlipCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;

        public void filter(CoordinateSequence seq, int i) {
            double x = seq.getOrdinate(i, 0);
            double y = seq.getOrdinate(i, 1);
            seq.setOrdinate(i, 0, y);
            seq.setOrdinate(i, 1, x);
            if (i == seq.size()) {
                this.done = true;
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean isGeometryChanged() {
            return true;
        }
    }
}

