/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_MultiplyZ
extends DeterministicScalarFunction {
    public ST_MultiplyZ() {
        this.addProperty("remarks", "This function do a multiplication with the z value of (each vertex of) the\n geometric parameter to the corresponding value given by a field.");
    }

    public String getJavaStaticMethod() {
        return "multiplyZ";
    }

    public static Geometry multiplyZ(Geometry geometry, double z) throws SQLException {
        if (geometry == null) {
            return null;
        }
        geometry.apply((CoordinateSequenceFilter)new MultiplyZCoordinateSequenceFilter(z));
        return geometry;
    }

    public static class MultiplyZCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private boolean done = false;
        private final double z;

        public MultiplyZCoordinateSequenceFilter(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            Coordinate coord = seq.getCoordinate(i);
            double currentZ = coord.z;
            if (!Double.isNaN(currentZ)) {
                seq.setOrdinate(i, 2, currentZ * this.z);
            }
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

