/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.processing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.precision.GeometryPrecisionReducer;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_PrecisionReducer
extends DeterministicScalarFunction {
    public ST_PrecisionReducer() {
        this.addProperty("remarks", "Reduce the geometry precision. Decimal_Place is the number of decimals to keep.");
    }

    public String getJavaStaticMethod() {
        return "precisionReducer";
    }

    public static Geometry precisionReducer(Geometry geometry, int nbDec) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (nbDec < 0) {
            throw new SQLException("Decimal_places has to be >= 0.");
        }
        PrecisionModel pm = new PrecisionModel(ST_PrecisionReducer.scaleFactorForDecimalPlaces(nbDec));
        GeometryPrecisionReducer geometryPrecisionReducer = new GeometryPrecisionReducer(pm);
        return geometryPrecisionReducer.reduce(geometry);
    }

    public static double scaleFactorForDecimalPlaces(int decimalPlaces) {
        return Math.pow(10.0, decimalPlaces);
    }
}

