/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.properties;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_3DLength
extends DeterministicScalarFunction {
    public ST_3DLength() {
        this.addProperty("remarks", "Returns the 3D length (of a LineString) or the 3D perimeter (of a Polygon).\nNote : For 2D geometries, returns the 2D length.");
    }

    public String getJavaStaticMethod() {
        return "stLength3D";
    }

    public static Double stLength3D(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            return ST_3DLength.length3D(geom);
        }
        return 0.0;
    }

    public static double length3D(Geometry geom) {
        double sum = 0.0;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            sum += ST_3DLength.length3D((LineString)geom.getGeometryN(i));
        }
        return sum;
    }

    public static double length3D(Polygon polygon) {
        double length = 0.0;
        length += ST_3DLength.length3D(polygon.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            length += ST_3DLength.length3D(polygon.getInteriorRingN(i));
        }
        return length;
    }

    public static double length3D(LineString lineString) {
        return ST_3DLength.length3D(lineString.getCoordinateSequence());
    }

    public static double length3D(CoordinateSequence points) {
        int numberOfCoords = points.size();
        if (numberOfCoords < 2) {
            return 0.0;
        }
        Coordinate currentCoord = new Coordinate();
        points.getCoordinate(0, currentCoord);
        double x0 = currentCoord.x;
        double y0 = currentCoord.y;
        double z0 = currentCoord.z;
        double length = 0.0;
        for (int i = 1; i < numberOfCoords; ++i) {
            points.getCoordinate(i, currentCoord);
            double x1 = currentCoord.x;
            double y1 = currentCoord.y;
            double z1 = currentCoord.z;
            double dx = x1 - x0;
            double dy = y1 - y0;
            double dz = Double.isNaN(z0) || Double.isNaN(z1) ? 0.0 : z1 - z0;
            length += Math.sqrt(dx * dx + dy * dy + dz * dz);
            x0 = x1;
            y0 = y1;
            z0 = z1;
        }
        return length;
    }
}

