/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_IsValidReason
extends DeterministicScalarFunction {
    public ST_IsValidReason() {
        this.addProperty("remarks", " Returns text stating if a geometry is valid or not and if not valid, a reason why.\nThe second argument is optional. It can have the following values (0 or 1)\n1 = It will validate inverted shells and exverted holes according the ESRI SDE model.\n0 = It will based on the OGC geometry model.");
    }

    public String getJavaStaticMethod() {
        return "isValidReason";
    }

    public static String isValidReason(Geometry geometry) {
        return ST_IsValidReason.isValidReason(geometry, 0);
    }

    public static String isValidReason(Geometry geometry, int flag) {
        if (geometry != null) {
            if (flag == 0) {
                return ST_IsValidReason.validReason(geometry, false);
            }
            if (flag == 1) {
                return ST_IsValidReason.validReason(geometry, true);
            }
            throw new IllegalArgumentException("Supported arguments are 0 or 1.");
        }
        return "Null Geometry";
    }

    private static String validReason(Geometry geometry, boolean flag) {
        IsValidOp validOP = new IsValidOp(geometry);
        validOP.setSelfTouchingRingFormingHoleValid(flag);
        TopologyValidationError error = validOP.getValidationError();
        if (error != null) {
            return error.toString();
        }
        return "Valid Geometry";
    }
}

