/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Perimeter
extends DeterministicScalarFunction {
    public ST_Perimeter() {
        this.addProperty("remarks", "Returns the length measurement of the boundary of a Polygon or a MultiPolygon. \nDistance units are those of the geometry spatial reference system.");
    }

    public String getJavaStaticMethod() {
        return "perimeter";
    }

    public static Double perimeter(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry.getDimension() < 2) {
            return 0.0;
        }
        return ST_Perimeter.computePerimeter(geometry);
    }

    private static double computePerimeter(Geometry geometry) {
        double sum = 0.0;
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeom = geometry.getGeometryN(i);
            if (!(subGeom instanceof Polygon)) continue;
            sum += ((Polygon)subGeom).getExteriorRing().getLength();
        }
        return sum;
    }
}

