/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatialext.function.spatial.trigonometry;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_Azimuth
extends DeterministicScalarFunction {
    public ST_Azimuth() {
        this.addProperty("remarks", "Returns the azimuth of the segment defined by the given Point geometries, \nor Null if the two points are coincident. Return value is in radians. \n Angle is computed clockwise from the north equals to 0.");
    }

    public String getJavaStaticMethod() {
        return "azimuth";
    }

    public static Double azimuth(Geometry pointA, Geometry pointB) {
        if (pointA == null || pointB == null) {
            return null;
        }
        if (pointA instanceof Point && pointB instanceof Point) {
            double x0 = ((Point)pointA).getX();
            double y0 = ((Point)pointA).getY();
            double x1 = ((Point)pointB).getX();
            double y1 = ((Point)pointB).getY();
            Double angle = x0 == x1 ? (y0 < y1 ? Double.valueOf(0.0) : (y0 > y1 ? Double.valueOf(Math.PI) : null)) : (y0 == y1 ? (x0 < x1 ? Double.valueOf(1.5707963267948966) : (x0 > x1 ? Double.valueOf(4.71238898038469) : null)) : (x0 < x1 ? (y0 < y1 ? Double.valueOf(Math.atan(Math.abs(x0 - x1) / Math.abs(y0 - y1))) : Double.valueOf(Math.atan(Math.abs(y0 - y1) / Math.abs(x0 - x1)) + 1.5707963267948966)) : (y0 > y1 ? Double.valueOf(Math.atan(Math.abs(x0 - x1) / Math.abs(y0 - y1)) + Math.PI) : Double.valueOf(Math.atan(Math.abs(y0 - y1) / Math.abs(x0 - x1)) + 4.71238898038469))));
            return angle;
        }
        return null;
    }
}

