/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Aggregate;
import org.h2.tools.RunScript;
import org.h2gis.h2spatial.internal.function.HexToVarBinary;
import org.h2gis.h2spatial.internal.function.spatial.aggregate.ST_Accum;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_AsBinary;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_AsText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_AsWKT;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_GeomFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_GeomFromWKB;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_LineFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_LineFromWKB;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_MLineFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_MPointFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_MPolyFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_PointFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_PointFromWKB;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_PolyFromText;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_PolyFromWKB;
import org.h2gis.h2spatial.internal.function.spatial.crs.ST_SetSRID;
import org.h2gis.h2spatial.internal.function.spatial.crs.ST_Transform;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_Buffer;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_ConvexHull;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_Difference;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_Intersection;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_SymDifference;
import org.h2gis.h2spatial.internal.function.spatial.operators.ST_Union;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Contains;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Crosses;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Disjoint;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_EnvelopesIntersect;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Equals;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Intersects;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_OrderingEquals;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Overlaps;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Relate;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Touches;
import org.h2gis.h2spatial.internal.function.spatial.predicates.ST_Within;
import org.h2gis.h2spatial.internal.function.spatial.properties.ColumnSRID;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Area;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Boundary;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Centroid;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_CoordDim;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Dimension;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Distance;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_EndPoint;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Envelope;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_ExteriorRing;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_GeometryN;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_GeometryType;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_GeometryTypeCode;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_InteriorRingN;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Is3D;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_IsClosed;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_IsEmpty;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_IsRing;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_IsSimple;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Length;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_NumGeometries;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_NumInteriorRing;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_NumInteriorRings;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_NumPoints;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_PointN;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_PointOnSurface;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_SRID;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_StartPoint;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_X;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Y;
import org.h2gis.h2spatial.internal.function.spatial.properties.ST_Z;
import org.h2gis.h2spatial.internal.type.DimensionFromConstraint;
import org.h2gis.h2spatial.internal.type.DomainInfo;
import org.h2gis.h2spatial.internal.type.GeometryTypeFromConstraint;
import org.h2gis.h2spatial.internal.type.GeometryTypeNameFromConstraint;
import org.h2gis.h2spatialapi.Function;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSpatialExtension {
    public static final String GEOMETRY_BASE_TYPE = "GEOMETRY";
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateSpatialExtension.class);

    public static Function[] getBuiltInsFunctions() {
        return new Function[]{new HexToVarBinary(), new GeometryTypeFromConstraint(), new ColumnSRID(), new GeometryTypeNameFromConstraint(), new DimensionFromConstraint(), new ST_GeomFromText(), new ST_Area(), new ST_AsBinary(), new ST_GeometryType(), new ST_PointFromText(), new ST_MPointFromText(), new ST_LineFromText(), new ST_MLineFromText(), new ST_PolyFromText(), new ST_MPolyFromText(), new ST_Dimension(), new ST_AsText(), new ST_AsWKT(), new ST_PolyFromWKB(), new ST_IsEmpty(), new ST_IsSimple(), new ST_Boundary(), new ST_Envelope(), new ST_X(), new ST_Y(), new ST_Z(), new ST_StartPoint(), new ST_EndPoint(), new ST_IsClosed(), new ST_IsRing(), new ST_LineFromWKB(), new ST_Length(), new ST_NumPoints(), new ST_PointN(), new ST_Centroid(), new ST_PointOnSurface(), new ST_Contains(), new ST_ExteriorRing(), new ST_NumInteriorRings(), new ST_NumInteriorRing(), new ST_InteriorRingN(), new ST_NumGeometries(), new ST_GeometryN(), new ST_Equals(), new ST_Disjoint(), new ST_Touches(), new ST_Within(), new ST_Overlaps(), new ST_Crosses(), new ST_Intersects(), new ST_Relate(), new ST_Distance(), new ST_Intersection(), new ST_Difference(), new ST_Union(), new ST_SymDifference(), new ST_Buffer(), new ST_ConvexHull(), new ST_SRID(), new ST_EnvelopesIntersect(), new ST_Accum(), new ST_Transform(), new ST_SetSRID(), new ST_CoordDim(), new ST_GeometryTypeCode(), new ST_OrderingEquals(), new ST_Is3D(), new ST_PointFromWKB(), new ST_GeomFromWKB()};
    }

    public static DomainInfo[] getBuiltInsType() {
        return new DomainInfo[]{new DomainInfo("POINT", 1), new DomainInfo("LINESTRING", 2), new DomainInfo("POLYGON", 3), new DomainInfo("GEOMCOLLECTION", 7), new DomainInfo("MULTIPOINT", 4), new DomainInfo("MULTILINESTRING", 5), new DomainInfo("MULTIPOLYGON", 6)};
    }

    public static void initSpatialExtension(Connection connection, String BundleSymbolicName, String BundleVersion) throws SQLException {
        String packagePrepend = BundleSymbolicName + ":" + BundleVersion + ":";
        CreateSpatialExtension.addSpatialFunctions(connection, packagePrepend);
        CreateSpatialExtension.registerGeometryType(connection);
        connection.commit();
    }

    public static void initSpatialExtension(Connection connection) throws SQLException {
        CreateSpatialExtension.addSpatialFunctions(connection, "");
        CreateSpatialExtension.registerGeometryType(connection);
        CreateSpatialExtension.registerSpatialTables(connection);
    }

    public static void registerGeometryType(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        for (DomainInfo domainInfo : CreateSpatialExtension.getBuiltInsType()) {
            st.execute("CREATE DOMAIN IF NOT EXISTS " + domainInfo.getDomainName() + " AS " + GEOMETRY_BASE_TYPE + "(" + domainInfo.getGeometryTypeCode() + ") CHECK (ST_GeometryTypeCode(VALUE) = " + domainInfo.getGeometryTypeCode() + ");");
        }
    }

    public static void registerSpatialTables(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        st.execute("drop view if exists geometry_columns");
        st.execute("create view geometry_columns as select TABLE_CATALOG f_table_catalog,TABLE_SCHEMA f_table_schema,TABLE_NAME f_table_name,COLUMN_NAME f_geometry_column,1 storage_type,_GeometryTypeFromConstraint(CHECK_CONSTRAINT || REMARKS, NUMERIC_PRECISION) geometry_type,_DimensionFromConstraint(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME,CHECK_CONSTRAINT) coord_dimension,_ColumnSRID(TABLE_CATALOG,TABLE_SCHEMA, TABLE_NAME,COLUMN_NAME,CHECK_CONSTRAINT) srid, _GeometryTypeNameFromConstraint(CHECK_CONSTRAINT || REMARKS, NUMERIC_PRECISION) type from INFORMATION_SCHEMA.COLUMNS WHERE TYPE_NAME = 'GEOMETRY'");
        ResultSet rs = connection.getMetaData().getTables("", "PUBLIC", "SPATIAL_REF_SYS", null);
        if (!rs.next()) {
            InputStreamReader reader = new InputStreamReader(CreateSpatialExtension.class.getResourceAsStream("spatial_ref_sys.sql"));
            RunScript.execute((Connection)connection, (Reader)reader);
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void unRegisterGeometryType(Connection connection) throws SQLException {
        DomainInfo[] domainInfos;
        Statement st = connection.createStatement();
        for (DomainInfo domainInfo : domainInfos = CreateSpatialExtension.getBuiltInsType()) {
            st.execute("DROP DOMAIN IF EXISTS " + domainInfo.getDomainName());
        }
    }

    private static String getStringProperty(Function function, String propertyKey) {
        Object value = function.getProperty(propertyKey);
        return value instanceof String ? (String)value : "";
    }

    private static boolean getBooleanProperty(Function function, String propertyKey, boolean defaultValue) {
        Object value = function.getProperty(propertyKey);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static void registerFunction(Statement st, Function function, String packagePrepend) throws SQLException {
        CreateSpatialExtension.registerFunction(st, function, packagePrepend, true);
    }

    public static void registerFunction(Statement st, Function function, String packagePrepend, boolean dropAlias) throws SQLException {
        String functionClass = function.getClass().getName();
        String functionAlias = CreateSpatialExtension.getAlias(function);
        if (function instanceof ScalarFunction) {
            ScalarFunction scalarFunction = (ScalarFunction)function;
            String functionName = scalarFunction.getJavaStaticMethod();
            if (dropAlias) {
                try {
                    st.execute("DROP ALIAS IF EXISTS " + functionAlias);
                }
                catch (SQLException ex) {
                    LOGGER.debug(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            String deterministic = "";
            if (CreateSpatialExtension.getBooleanProperty(function, "deterministic", false)) {
                deterministic = " DETERMINISTIC";
            }
            String nobuffer = "";
            if (CreateSpatialExtension.getBooleanProperty(function, "nobuffer", false)) {
                nobuffer = " NOBUFFER";
            }
            st.execute("CREATE FORCE ALIAS IF NOT EXISTS " + functionAlias + deterministic + nobuffer + " FOR \"" + packagePrepend + functionClass + "." + functionName + "\"");
            String functionRemarks = CreateSpatialExtension.getStringProperty(function, "remarks");
            if (!functionRemarks.isEmpty()) {
                PreparedStatement ps = st.getConnection().prepareStatement("COMMENT ON ALIAS " + functionAlias + " IS ?");
                ps.setString(1, functionRemarks);
                ps.execute();
            }
        } else if (function instanceof Aggregate) {
            if (dropAlias) {
                st.execute("DROP AGGREGATE IF EXISTS " + functionAlias);
            }
            st.execute("CREATE FORCE AGGREGATE IF NOT EXISTS " + functionAlias + " FOR \"" + packagePrepend + functionClass + "\"");
        } else {
            throw new SQLException("Unsupported function " + functionClass);
        }
    }

    public static String getAlias(Function function) {
        String functionAlias = CreateSpatialExtension.getStringProperty(function, "name");
        if (!functionAlias.isEmpty()) {
            return functionAlias;
        }
        return function.getClass().getSimpleName();
    }

    public static void unRegisterFunction(Statement st, Function function) throws SQLException {
        String functionAlias = CreateSpatialExtension.getStringProperty(function, "name");
        if (functionAlias.isEmpty()) {
            functionAlias = function.getClass().getSimpleName();
        }
        st.execute("DROP ALIAS IF EXISTS " + functionAlias);
    }

    private static void addSpatialFunctions(Connection connection, String packagePrepend) throws SQLException {
        Statement st = connection.createStatement();
        for (Function function : CreateSpatialExtension.getBuiltInsFunctions()) {
            try {
                CreateSpatialExtension.registerFunction(st, function, packagePrepend);
            }
            catch (SQLException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public static void disposeSpatialExtension(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        for (Function function : CreateSpatialExtension.getBuiltInsFunctions()) {
            CreateSpatialExtension.unRegisterFunction(st, function);
        }
        CreateSpatialExtension.unRegisterGeometryType(connection);
    }
}

