/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.internal.function.spatial.aggregate;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.h2.api.Aggregate;
import org.h2gis.h2spatialapi.AbstractFunction;

public class ST_Accum
extends AbstractFunction
implements Aggregate {
    private List<Geometry> toUnite = new LinkedList<Geometry>();
    private int minDim = Integer.MAX_VALUE;
    private int maxDim = Integer.MIN_VALUE;

    public ST_Accum() {
        this.addProperty("remarks", "This aggregate function returns a GeometryCollection.");
    }

    public void init(Connection connection) throws SQLException {
    }

    public int getInternalType(int[] inputTypes) throws SQLException {
        if (inputTypes.length != 1) {
            throw new SQLException(ST_Accum.class.getSimpleName() + " expects 1 argument.");
        }
        if (inputTypes[0] != 22) {
            throw new SQLException(ST_Accum.class.getSimpleName() + " expects a Geometry argument");
        }
        return 22;
    }

    private void feedDim(Geometry geometry) {
        int geomDim = geometry.getDimension();
        this.maxDim = Math.max(this.maxDim, geomDim);
        this.minDim = Math.min(this.minDim, geomDim);
    }

    private void addGeometry(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            ArrayList<Geometry> toUnitTmp = new ArrayList<Geometry>(geom.getNumGeometries());
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                toUnitTmp.add(geom.getGeometryN(i));
                this.feedDim(geom.getGeometryN(i));
            }
            this.toUnite.addAll(toUnitTmp);
        } else {
            this.toUnite.add(geom);
            this.feedDim(geom);
        }
    }

    public void add(Object o) throws SQLException {
        if (o instanceof Geometry) {
            Geometry geom = (Geometry)o;
            this.addGeometry(geom);
        } else if (o != null) {
            throw new SQLException("ST_Accum accepts only Geometry values. Input: " + o.getClass().getSimpleName());
        }
    }

    public GeometryCollection getResult() throws SQLException {
        GeometryFactory factory = new GeometryFactory();
        if (this.maxDim != this.minDim) {
            return factory.createGeometryCollection(this.toUnite.toArray(new Geometry[this.toUnite.size()]));
        }
        switch (this.maxDim) {
            case 0: {
                return factory.createMultiPoint(this.toUnite.toArray(new Point[this.toUnite.size()]));
            }
            case 1: {
                return factory.createMultiLineString(this.toUnite.toArray(new LineString[this.toUnite.size()]));
            }
        }
        return factory.createMultiPolygon(this.toUnite.toArray(new Polygon[this.toUnite.size()]));
    }
}

