/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.internal.function.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.GeometryMetaData;

public class ST_PointFromWKB
extends DeterministicScalarFunction {
    public ST_PointFromWKB() {
        this.addProperty("remarks", "Convert Well Known Binary into a POINT.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toPoint";
    }

    public static Geometry toPoint(byte[] bytes) throws SQLException, IOException {
        return ST_PointFromWKB.toPoint(bytes, 0);
    }

    public static Geometry toPoint(byte[] bytes, int srid) throws SQLException, IOException {
        if (bytes == null) {
            return null;
        }
        WKBReader wkbReader = new WKBReader();
        try {
            if (GeometryMetaData.getMetaDataFromWKB((byte[])bytes).geometryType != 1) {
                throw new SQLException("Provided WKB is not a POINT.");
            }
            Geometry geometry = wkbReader.read(bytes);
            geometry.setSRID(srid);
            return geometry;
        }
        catch (ParseException ex) {
            throw new SQLException("ParseException while evaluating ST_PointFromWKB", ex);
        }
    }
}

