/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.internal.function.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.h2spatial.internal.function.spatial.convert.ST_GeomFromText;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_PolyFromText
extends DeterministicScalarFunction {
    public ST_PolyFromText() {
        this.addProperty("remarks", "Convert a WKT String into a POLYGON.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String wKT) throws SQLException {
        return ST_PolyFromText.toGeometry(wKT, 0);
    }

    public static Geometry toGeometry(String wKT, int srid) throws SQLException {
        Geometry geometry = ST_GeomFromText.toGeometry(wKT, srid);
        if (!geometry.getGeometryType().equalsIgnoreCase("POLYGON")) {
            throw new SQLException("The provided WKT Geometry is not a POLYGON.");
        }
        return geometry;
    }
}

