/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.internal.function.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_InteriorRingN
extends DeterministicScalarFunction {
    private static final String OUT_OF_BOUNDS_ERR_MESSAGE = "Interior ring index out of range. Must be between 1 and ST_NumInteriorRings.";

    public ST_InteriorRingN() {
        this.addProperty("remarks", "Returns interior ring number n from a Polygon. Use ST_NumInteriorRings to retrieve the total number of interior rings.");
    }

    public String getJavaStaticMethod() {
        return "getInteriorRing";
    }

    public static LineString getInteriorRing(Geometry geometry, Integer n) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            if (n >= 1 && n <= polygon.getNumInteriorRing()) {
                return polygon.getInteriorRingN(n - 1);
            }
            throw new SQLException(OUT_OF_BOUNDS_ERR_MESSAGE);
        }
        return null;
    }
}

