/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.internal.function.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_NumInteriorRings
extends DeterministicScalarFunction {
    public ST_NumInteriorRings() {
        this.addProperty("remarks", "Return the number of holes in a geometry.");
    }

    public String getJavaStaticMethod() {
        return "getHoles";
    }

    public static Integer getHoles(Geometry g) {
        if (g == null) {
            return null;
        }
        int holes = 0;
        if (g instanceof GeometryCollection) {
            int geomCount = g.getNumGeometries();
            for (int i = 0; i < geomCount; ++i) {
                holes += ST_NumInteriorRings.getHoles(g.getGeometryN(i)).intValue();
            }
        } else if (g instanceof Polygon) {
            holes = ((Polygon)g).getNumInteriorRing();
        }
        return holes;
    }
}

