/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.h2spatial.ut;

import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.h2.Driver;
import org.h2.util.OsgiDataSourceFactory;
import org.h2gis.h2spatial.CreateSpatialExtension;

public class SpatialH2UT {
    public static final String H2_PARAMETERS = ";LOCK_MODE=0;LOG=0;DB_CLOSE_DELAY=5";

    private SpatialH2UT() {
    }

    public static Connection openSpatialDataBase(String dbName) throws SQLException, ClassNotFoundException {
        String dbFilePath = SpatialH2UT.getDataBasePath(dbName);
        String databasePath = "jdbc:h2:" + dbFilePath + H2_PARAMETERS;
        Driver.load();
        return DriverManager.getConnection(databasePath, "sa", "sa");
    }

    public static Connection createSpatialDataBase(String dbName) throws SQLException, ClassNotFoundException {
        return SpatialH2UT.createSpatialDataBase(dbName, true);
    }

    private static String getDataBasePath(String dbName) {
        if (dbName.startsWith("file://")) {
            return new File(URI.create(dbName)).getAbsolutePath();
        }
        return new File("target/test-resources/dbH2" + dbName).getAbsolutePath();
    }

    public static DataSource createDataSource(String dbName, boolean initSpatial) throws SQLException {
        return SpatialH2UT.createDataSource(dbName, initSpatial, H2_PARAMETERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource createDataSource(String dbName, boolean initSpatial, String h2Parameters) throws SQLException {
        Driver driver = Driver.load();
        OsgiDataSourceFactory dataSourceFactory = new OsgiDataSourceFactory(driver);
        Properties properties = new Properties();
        String databasePath = SpatialH2UT.initDBFile(dbName, h2Parameters);
        properties.setProperty("url", databasePath);
        properties.setProperty("user", "sa");
        properties.setProperty("password", "sa");
        DataSource dataSource = dataSourceFactory.createDataSource(properties);
        if (initSpatial) {
            Connection connection = dataSource.getConnection();
            try {
                CreateSpatialExtension.initSpatialExtension(connection);
            }
            finally {
                connection.close();
            }
        }
        return dataSource;
    }

    private static String initDBFile(String dbName, String h2_PARAMETERS) {
        String dbFilePath = SpatialH2UT.getDataBasePath(dbName);
        File dbFile = new File(dbFilePath + ".mv.db");
        String databasePath = "jdbc:h2:" + dbFilePath + h2_PARAMETERS;
        if (dbFile.exists()) {
            dbFile.delete();
        }
        if ((dbFile = new File(dbFilePath + ".mv.db")).exists()) {
            dbFile.delete();
        }
        return databasePath;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial, String h2Parameters) throws SQLException, ClassNotFoundException {
        String databasePath = SpatialH2UT.initDBFile(dbName, h2Parameters);
        Driver.load();
        Connection connection = DriverManager.getConnection(databasePath, "sa", "sa");
        Statement st = connection.createStatement();
        st.execute("CREATE TABLE dummy(id INTEGER);");
        st.execute("INSERT INTO dummy values (1)");
        if (initSpatial) {
            CreateSpatialExtension.initSpatialExtension(connection);
        }
        return connection;
    }

    public static Connection createSpatialDataBase(String dbName, boolean initSpatial) throws SQLException, ClassNotFoundException {
        return SpatialH2UT.createSpatialDataBase(dbName, initSpatial, H2_PARAMETERS);
    }
}

