/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.directivity;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class DirectivityRecord {
    double theta;
    double phi;
    double[] attenuation;

    public DirectivityRecord(double theta, double phi, double[] attenuation) {
        this.theta = theta;
        this.phi = phi;
        this.attenuation = attenuation;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectivityRecord record = (DirectivityRecord)o;
        return Double.compare(record.theta, this.theta) == 0 && Double.compare(record.phi, this.phi) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.theta, this.phi);
    }

    public String toString() {
        return String.format(Locale.ROOT, "DirectivityRecord{theta=%.2f (%.2g\u00b0), phi=%.2f (%.2g\u00b0) , attenuation=%s}", this.theta, Math.toDegrees(this.theta), this.phi, Math.toDegrees(this.phi), Arrays.toString(this.attenuation));
    }

    public double[] getAttenuation() {
        return this.attenuation;
    }
}

