/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.directivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noise_planet.noisemodelling.emission.directivity.DirectivityRecord;
import org.noise_planet.noisemodelling.emission.directivity.DirectivitySphere;
import org.noise_planet.noisemodelling.emission.directivity.PhiComparator;
import org.noise_planet.noisemodelling.emission.directivity.ThetaComparator;
import org.noise_planet.noisemodelling.emission.utils.Utils;

public class DiscreteDirectivitySphere
implements DirectivitySphere {
    int interpolationMethod = 1;
    int directionIdentifier;
    double[] frequencies;
    Map<Long, Integer> frequencyMapping = new HashMap<Long, Integer>();
    List<DirectivityRecord> recordsTheta = new ArrayList<DirectivityRecord>();
    List<DirectivityRecord> recordsPhi = new ArrayList<DirectivityRecord>();
    ThetaComparator thetaComparator = new ThetaComparator();
    PhiComparator phiComparator = new PhiComparator();

    public DiscreteDirectivitySphere(int directionIdentifier, double[] frequencies) {
        this.directionIdentifier = directionIdentifier;
        this.frequencies = frequencies;
        for (int idFrequency = 0; idFrequency < frequencies.length; ++idFrequency) {
            this.frequencyMapping.put(Double.doubleToLongBits(frequencies[idFrequency]), idFrequency);
        }
    }

    private static double getDistance(double theta, double phi, DirectivityRecord b) {
        return Math.acos(Math.sin(phi) * Math.sin(b.phi) + Math.cos(phi) * Math.cos(b.phi) * Math.cos(theta - b.theta));
    }

    public void setInterpolationMethod(int interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
    }

    public List<DirectivityRecord> getRecordsTheta() {
        return this.recordsTheta;
    }

    public List<DirectivityRecord> getRecordsPhi() {
        return this.recordsPhi;
    }

    public int getDirectionIdentifier() {
        return this.directionIdentifier;
    }

    @Override
    public double getAttenuation(double frequency, double phi, double theta) {
        return this.getAttenuationArray(new double[]{frequency}, phi, theta)[0];
    }

    @Override
    public double[] getAttenuationArray(double[] requestFrequencies, double phi, double theta) {
        DirectivityRecord query = new DirectivityRecord(theta, phi, null);
        DirectivityRecord record = this.getRecord(query.theta, query.phi, this.interpolationMethod);
        double[] returnAttenuation = new double[requestFrequencies.length];
        for (int frequencyIndex = 0; frequencyIndex < requestFrequencies.length; ++frequencyIndex) {
            double frequency = requestFrequencies[frequencyIndex];
            Integer idFreq = this.frequencyMapping.get(Double.doubleToLongBits(frequency));
            if (idFreq == null && (idFreq = Integer.valueOf(Arrays.binarySearch(this.frequencies, frequency))) < 0) {
                int last = Math.min(-idFreq.intValue() - 1, this.frequencies.length - 1);
                int first = Math.max(last - 1, 0);
                idFreq = Math.abs(this.frequencies[first] - frequency) < Math.abs(this.frequencies[last] - frequency) ? first : last;
            }
            returnAttenuation[frequencyIndex] = record.attenuation[idFreq];
        }
        return returnAttenuation;
    }

    public void addDirectivityRecord(double theta, double phi, double[] attenuation) {
        DirectivityRecord record = new DirectivityRecord(theta, phi, attenuation);
        int index = Collections.binarySearch(this.recordsTheta, record, this.thetaComparator);
        if (index >= 0) {
            return;
        }
        index = -index - 1;
        this.recordsTheta.add(index, record);
        index = Collections.binarySearch(this.recordsPhi, record, this.phiComparator);
        index = -index - 1;
        this.recordsPhi.add(index, record);
    }

    public double[] getFrequencies() {
        return this.frequencies;
    }

    public DirectivityRecord getRecord(double theta, double phi, int interpolate) {
        DirectivityRecord[] allRecords = null;
        DirectivityRecord record = new DirectivityRecord(theta, phi, null);
        int index = Collections.binarySearch(this.recordsTheta, record, this.thetaComparator);
        if (index >= 0) {
            return this.recordsTheta.get(index);
        }
        if ((index = -index - 1) >= this.recordsTheta.size()) {
            index = 0;
        }
        double theta2 = this.recordsTheta.get(index).getTheta();
        if (--index < 0) {
            index = this.recordsTheta.size() - 1;
        }
        double theta1 = this.recordsTheta.get(index).getTheta();
        index = Collections.binarySearch(this.recordsPhi, record, this.phiComparator);
        if ((index = -index - 1) >= this.recordsPhi.size()) {
            index = 0;
        }
        double phi2 = this.recordsPhi.get(index).getPhi();
        if (--index < 0) {
            index = this.recordsPhi.size() - 1;
        }
        double phi1 = this.recordsPhi.get(index).getPhi();
        int[] indexes = new int[]{Collections.binarySearch(this.recordsTheta, new DirectivityRecord(theta1, phi1, null), this.thetaComparator), Collections.binarySearch(this.recordsTheta, new DirectivityRecord(theta2, phi1, null), this.thetaComparator), Collections.binarySearch(this.recordsTheta, new DirectivityRecord(theta2, phi2, null), this.thetaComparator), Collections.binarySearch(this.recordsTheta, new DirectivityRecord(theta1, phi2, null), this.thetaComparator)};
        if (Arrays.stream(indexes).min().getAsInt() < 0) {
            return new DirectivityRecord(theta, phi, new double[this.frequencies.length]);
        }
        allRecords = new DirectivityRecord[]{this.recordsTheta.get(indexes[0]), this.recordsTheta.get(indexes[1]), this.recordsTheta.get(indexes[2]), this.recordsTheta.get(indexes[3])};
        if (interpolate == 0) {
            double minDist = Double.MAX_VALUE;
            DirectivityRecord closest = allRecords[0];
            for (DirectivityRecord r : allRecords) {
                double testDist = DiscreteDirectivitySphere.getDistance(theta, phi, r);
                if (!(testDist < minDist)) continue;
                minDist = testDist;
                closest = r;
            }
            return closest;
        }
        double x1 = allRecords[0].theta;
        double y1 = allRecords[0].phi;
        double xLength = DiscreteDirectivitySphere.getDistance(allRecords[1].theta, allRecords[0].phi, allRecords[0]);
        double yLength = DiscreteDirectivitySphere.getDistance(allRecords[0].theta, allRecords[2].phi, allRecords[0]);
        double x = Math.max(0.0, Math.min(1.0, DiscreteDirectivitySphere.getDistance(x1, record.phi, record) / xLength));
        double y = Math.max(0.0, Math.min(1.0, DiscreteDirectivitySphere.getDistance(record.theta, y1, record) / yLength));
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        double[] att = new double[this.frequencies.length];
        for (int idFrequency = 0; idFrequency < this.frequencies.length; ++idFrequency) {
            att[idFrequency] = Utils.wToDb(Utils.dbToW(allRecords[0].attenuation[idFrequency]) * (1.0 - x) * (1.0 - y) + Utils.dbToW(allRecords[1].attenuation[idFrequency]) * x * (1.0 - y) + Utils.dbToW(allRecords[3].attenuation[idFrequency]) * (1.0 - x) * y + Utils.dbToW(allRecords[2].attenuation[idFrequency]) * x * y);
        }
        return new DirectivityRecord(theta, phi, att);
    }

    public void addDirectivityRecords(Collection<DirectivityRecord> newRecords) {
        this.recordsTheta.addAll(newRecords);
        this.recordsTheta.sort(this.thetaComparator);
        this.recordsPhi.addAll(newRecords);
        this.recordsPhi.sort(this.phiComparator);
    }

    @Override
    public boolean coverFrequency(double frequency) {
        return Arrays.stream(this.frequencies).anyMatch(x -> x == frequency);
    }
}

