/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.directivity;

import java.util.Locale;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector2D;
import org.noise_planet.noisemodelling.emission.directivity.DirectivitySphere;

public class PolarGraphDirectivity {
    double dwidth = 500.0;
    double dheight = 500.0;
    double radius = this.dwidth / 2.0 - 80.0;
    double textRadius = this.radius + 25.0;
    double centerx = this.dwidth / 2.0;
    double centery = this.dheight / 2.0;

    private void generateLine(StringBuilder sb, double startX, double startY, double stopX, double stopY, String color) {
        sb.append(String.format(Locale.ROOT, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"%s\" stroke-width=\"1\" />\n", startX, startY, stopX, stopY, color));
    }

    private void generateDashedLine(StringBuilder sb, double startX, double startY, double stopX, double stopY, String color) {
        sb.append(String.format(Locale.ROOT, "<line x1=\"%f\" y1=\"%f\" x2=\"%f\" y2=\"%f\" stroke=\"%s\" stroke-width=\"1\" stroke-dashoffset=\"5\"  stroke-dasharray=\"5,5\" />\n", startX, startY, stopX, stopY, color));
    }

    private void generateText(StringBuilder sb, double startX, double startY, int fontSize, String text, String verticalAlignment) {
        sb.append(String.format(Locale.ROOT, "<text x=\"%f\" y=\"%f\" font-family=\"Verdana\" font-size=\"%d\"  text-anchor=\"middle\" dominant-baseline=\"%s\">%s</text>\n", startX, startY, fontSize, verticalAlignment, text));
    }

    private double toRadian(double angle) {
        return angle / 180.0 * Math.PI;
    }

    private double getAdjustedAngle(double angle, ORIENTATION orientation) {
        if (orientation == ORIENTATION.TOP) {
            return (angle + 90.0) % 360.0;
        }
        return (720.0 - angle) % 360.0;
    }

    private void generateLegend(StringBuilder sb, double value, double position, double angle) {
        double destX = this.centerx + Math.cos(this.toRadian(angle)) * this.radius * position;
        double destY = this.centery + Math.sin(this.toRadian(angle)) * this.radius * position;
        this.generateText(sb, destX, destY, 10, String.format(Locale.ROOT, "%.0f dB", value), "middle");
    }

    public String generatePolarGraph(DirectivitySphere noiseSource, double frequency, double minimumAttenuation, double maximumAttenuation, ORIENTATION orientation) {
        StringBuilder sb = new StringBuilder(String.format("<svg height=\"%d\" width=\"%d\">\n", (int)this.dheight, (int)this.dwidth));
        sb.append(String.format(Locale.ROOT, "<circle cx=\"%f\" cy=\"%f\" r=\"%f\" stroke=\"grey\" stroke-width=\"1\"  fill=\"transparent\"/>\n", this.centerx, this.centery, this.radius));
        sb.append(String.format(Locale.ROOT, "<circle cx=\"%f\" cy=\"%f\" r=\"%f\" stroke=\"grey\" stroke-width=\"1\"  fill=\"transparent\"  stroke-dasharray=\"5,5\"/>\n", this.centerx, this.centery, this.radius * 0.75));
        sb.append(String.format(Locale.ROOT, "<circle cx=\"%f\" cy=\"%f\" r=\"%f\" stroke=\"grey\" stroke-width=\"1\"  fill=\"transparent\"  stroke-dasharray=\"5,5\"/>\n", this.centerx, this.centery, this.radius * 0.5));
        sb.append(String.format(Locale.ROOT, "<circle cx=\"%f\" cy=\"%f\" r=\"%f\" stroke=\"grey\" stroke-width=\"1\"  fill=\"transparent\"  stroke-dasharray=\"5,5\"/>\n", this.centerx, this.centery, this.radius * 0.25));
        for (int angle = 0; angle < 360; angle += 30) {
            double destX = this.centerx + Math.cos(this.toRadian(angle)) * this.radius;
            double destY = this.centery + Math.sin(this.toRadian(angle)) * this.radius;
            double adjustedAngle = this.getAdjustedAngle(angle, orientation);
            if (angle % 90 != 0) {
                this.generateDashedLine(sb, this.centerx, this.centery, destX, destY, "grey");
            } else {
                this.generateLine(sb, this.centerx, this.centery, destX, destY, "grey");
            }
            double textX = this.centerx + Math.cos(this.toRadian(angle)) * this.textRadius;
            double textY = this.centery + Math.sin(this.toRadian(angle)) * this.textRadius;
            this.generateText(sb, textX, textY, 25, String.format(Locale.ROOT, "%d", (int)adjustedAngle), "middle");
        }
        double legendAngle = 285.0;
        this.generateLegend(sb, minimumAttenuation, 0.0, legendAngle);
        this.generateLegend(sb, minimumAttenuation + (maximumAttenuation - minimumAttenuation) * 0.25, 0.25, legendAngle);
        this.generateLegend(sb, minimumAttenuation + (maximumAttenuation - minimumAttenuation) * 0.5, 0.5, legendAngle);
        this.generateLegend(sb, minimumAttenuation + (maximumAttenuation - minimumAttenuation) * 0.75, 0.75, legendAngle);
        this.generateLegend(sb, maximumAttenuation, 1.0, legendAngle);
        StringBuilder path = new StringBuilder();
        for (int angle = 0; angle < 360; ++angle) {
            double phi = 0.0;
            double theta = 0.0;
            if (orientation == ORIENTATION.TOP) {
                phi = this.toRadian((angle + 90) % 360);
                theta = 0.0;
            } else {
                theta = angle <= 90 ? this.toRadian(-angle) : (angle < 180 ? -this.toRadian(90 - angle % 90) : (angle < 270 ? this.toRadian(angle % 90) : this.toRadian(90 - angle % 90)));
                if (orientation == ORIENTATION.FRONT) {
                    phi = angle <= 90 || angle >= 270 ? this.toRadian(270.0) : this.toRadian(90.0);
                } else if (orientation == ORIENTATION.SIDE) {
                    phi = angle <= 90 || angle >= 270 ? this.toRadian(0.0) : this.toRadian(180.0);
                }
            }
            double attenuation = noiseSource.getAttenuation(frequency, phi, theta);
            double maxLevelX = this.centerx + Math.cos(Math.toRadians(angle)) * this.radius;
            double maxLevelY = this.centery + Math.sin(Math.toRadians(angle)) * this.radius;
            double attenuationPercentage = (attenuation - minimumAttenuation) / (maximumAttenuation - minimumAttenuation);
            attenuationPercentage = Math.max(0.0, Math.min(1.0, attenuationPercentage));
            Vector2D interpolatedVector = Vector2D.create((Coordinate)new Coordinate(this.centerx, this.centery), (Coordinate)new Coordinate(maxLevelX, maxLevelY));
            interpolatedVector = interpolatedVector.multiply(attenuationPercentage);
            double stopX = this.centerx + interpolatedVector.getX();
            double stopY = this.centery + interpolatedVector.getY();
            if (angle == 0) {
                path.append(String.format(Locale.ROOT, "M %.1f %.1f", stopX, stopY));
            } else {
                path.append(String.format(Locale.ROOT, " L %.1f %.1f", stopX, stopY));
            }
            if (angle % 30 != 0) continue;
            path.append("\n");
        }
        path.append(" Z");
        sb.append("<path d=\"");
        sb.append(path.toString());
        sb.append("\"  fill=\"transparent\" stroke=\"red\" stroke-width=\"2\"/>\n");
        sb.append("</svg> \n");
        return sb.toString();
    }

    public double getDwidth() {
        return this.dwidth;
    }

    public void setDwidth(double dwidth) {
        this.dwidth = dwidth;
        this.centerx = dwidth / 2.0;
    }

    public double getDheight() {
        return this.dheight;
    }

    public void setDheight(double dheight) {
        this.dheight = dheight;
        this.centery = dheight / 2.0;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getTextRadius() {
        return this.textRadius;
    }

    public void setTextRadius(double textRadius) {
        this.textRadius = textRadius;
    }

    public double getCenterx() {
        return this.centerx;
    }

    public void setCenterx(double centerx) {
        this.centerx = centerx;
    }

    public double getCentery() {
        return this.centery;
    }

    public void setCentery(double centery) {
        this.centery = centery;
    }

    public static enum ORIENTATION {
        TOP,
        FRONT,
        SIDE;

    }
}

