/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.noise_planet.noisemodelling.emission.LineSource;
import org.noise_planet.noisemodelling.emission.utils.Utils;

public class RailWayParameters {
    public Map<String, LineSource> railwaySourceList = new HashMap<String, LineSource>();

    public Map<String, LineSource> getRailwaySourceList() {
        return this.railwaySourceList;
    }

    public void setRailwaySourceList(Map<String, LineSource> railwaySourceList) {
        this.railwaySourceList = railwaySourceList;
    }

    public void addRailwaySource(String ID, LineSource lineSource) {
        this.railwaySourceList.put(ID, lineSource);
    }

    public RailWayParameters sumRailwaySource(RailWayParameters lineSource1, RailWayParameters lineSource2) {
        if (!lineSource2.getRailwaySourceList().isEmpty()) {
            for (Map.Entry<String, LineSource> railwaySourceEntry : lineSource1.getRailwaySourceList().entrySet()) {
                double[] lW1 = railwaySourceEntry.getValue().getlW();
                double[] lW2 = lineSource2.getRailwaySourceList().get(railwaySourceEntry.getKey()).getlW();
                lineSource1.getRailwaySourceList().get(railwaySourceEntry.getKey()).setlW(Utils.sumDbArray(lW1, lW2));
            }
        }
        return lineSource1;
    }

    public void appendVperHour(double Qm, double vm) throws IOException {
        for (Map.Entry<String, LineSource> railwaySourceEntry : this.railwaySourceList.entrySet()) {
            double[] lW = railwaySourceEntry.getValue().getlW();
            for (int i = 0; i < railwaySourceEntry.getValue().getlW().length; ++i) {
                lW[i] = Utils.Vperhour2NoiseLevel(lW[i], Qm, vm);
            }
            railwaySourceEntry.getValue().setlW(lW);
        }
    }
}

