/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.noise_planet.noisemodelling.emission.railway.RailWayParameters;
import org.noise_planet.noisemodelling.emission.railway.RailwayTrackParameters;
import org.noise_planet.noisemodelling.emission.railway.RailwayVehicleParameters;

public class Railway {
    private JsonNode railWayData;
    private JsonNode vehicleData;
    private JsonNode trainsetData;

    private static JsonNode parse(InputStream inputStream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(inputStream);
        }
        catch (IOException ex) {
            return NullNode.getInstance();
        }
    }

    public static <T> Iterable<T> iteratorToIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public void setVehicleDataFile(String VehicleData) {
        this.vehicleData = Railway.parse(Railway.class.getResourceAsStream(VehicleData));
    }

    public void setTrainSetDataFile(String TrainsetData) {
        this.trainsetData = Railway.parse(Railway.class.getResourceAsStream(TrainsetData));
    }

    public void setRailwayDataFile(String RailWayData) {
        this.railWayData = Railway.parse(Railway.class.getResourceAsStream(RailWayData));
    }

    public JsonNode getVehicleNode(String typeVehicle) {
        JsonNode vehicle = this.vehicleData.get(typeVehicle);
        if (vehicle == null) {
            throw new IllegalArgumentException(String.format("Vehicle %s not found must be one of :\n -%s", typeVehicle, String.join((CharSequence)"\n -", Railway.iteratorToIterable(this.vehicleData.fieldNames()))));
        }
        return vehicle;
    }

    public JsonNode getRailWayData() {
        return this.railWayData;
    }

    public JsonNode getVehicleData() {
        return this.vehicleData;
    }

    public JsonNode getTrainsetData() {
        return this.trainsetData;
    }

    public Map<String, Integer> getVehicleFromTrainset(String trainName) {
        Map vehicles = null;
        Iterator it = this.getTrainsetData().fields();
        while (it.hasNext()) {
            Map.Entry elt = (Map.Entry)it.next();
            if (!trainName.equals(elt.getKey())) continue;
            ObjectMapper mapper = new ObjectMapper();
            vehicles = (Map)mapper.convertValue(elt.getValue(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
            break;
        }
        return vehicles;
    }

    public boolean isInVehicleList(String vehicleName) {
        boolean inlist = false;
        Iterator it = this.getVehicleData().fields();
        while (it.hasNext()) {
            Map.Entry elt = (Map.Entry)it.next();
            if (!vehicleName.equals(elt.getKey())) continue;
            inlist = true;
            break;
        }
        return inlist;
    }

    public RailWayParameters evaluate(RailwayVehicleParameters vehicleParameters, RailwayTrackParameters trackParameters) throws IOException {
        String typeVehicle = vehicleParameters.getTypeVehicle();
        double speedVehicle = vehicleParameters.getSpeedVehicle();
        double vehPerHour = vehicleParameters.getNumberVehicle();
        boolean isTunnel = trackParameters.getIsTunnel();
        if (isTunnel) {
            RailWayParameters lWRailWay = new RailWayParameters();
            return lWRailWay;
        }
        RailWayParameters lWRailWay = new RailWayParameters();
        return lWRailWay;
    }
}

