/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway.nmpb;

import java.util.Arrays;
import org.noise_planet.noisemodelling.emission.utils.Utils;

public class RailWayNMPBParameters {
    public static final int[] TRAIN_NOISE_SOURCE_H_INDEX = new int[]{0, 0, 1, 0, 1, 0};
    public static final Integer[] DEFAULT_FREQUENCIES_THIRD_OCTAVE = new Integer[]{50, 63, 80, 100, 125, 160, 200, 250, 315, 400, 500, 630, 800, 1000, 1250, 1600, 2000, 2500, 3150, 4000, 5000, 6300, 8000, 10000};
    private double[] lWRolling = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
    private double[] lWTractionA = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
    private double[] lWTractionB = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
    private double[] lWAerodynamicA = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
    private double[] lWAerodynamicB = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
    private double[] lWBridge = new double[DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];

    public RailWayNMPBParameters() {
        Arrays.fill(this.lWRolling, -99.99);
        Arrays.fill(this.lWTractionA, -99.99);
        Arrays.fill(this.lWTractionB, -99.99);
        Arrays.fill(this.lWAerodynamicA, -99.99);
        Arrays.fill(this.lWAerodynamicB, -99.99);
        Arrays.fill(this.lWBridge, -99.99);
        this.setLWRolling(this.lWRolling);
        this.setLWTractionA(this.lWTractionA);
        this.setLWTractionB(this.lWTractionB);
        this.setLWAerodynamicA(this.lWAerodynamicA);
        this.setLWAerodynamicB(this.lWAerodynamicB);
        this.setLWBridge(this.lWBridge);
    }

    public RailWayNMPBParameters(double[] lWRolling, double[] lWTractionA, double[] lWTractionB, double[] lWAerodynamicA, double[] lWAerodynamicB, double[] lWBridge) {
        this.setLWRolling(lWRolling);
        this.setLWTractionA(lWTractionA);
        this.setLWTractionB(lWTractionB);
        this.setLWAerodynamicA(lWAerodynamicA);
        this.setLWAerodynamicB(lWAerodynamicB);
        this.setLWBridge(lWBridge);
    }

    public static RailWayNMPBParameters sumRailWayLW(RailWayNMPBParameters railWayLW1, RailWayNMPBParameters railWayLW2) {
        RailWayNMPBParameters railWayLW = new RailWayNMPBParameters();
        railWayLW.setLWRolling(Utils.sumDbArray(railWayLW1.getLWRolling(), railWayLW2.getLWRolling()));
        railWayLW.setLWAerodynamicA(Utils.sumDbArray(railWayLW1.getLWAerodynamicA(), railWayLW2.getLWAerodynamicA()));
        railWayLW.setLWAerodynamicB(Utils.sumDbArray(railWayLW1.getLWAerodynamicB(), railWayLW2.getLWAerodynamicB()));
        railWayLW.setLWBridge(Utils.sumDbArray(railWayLW1.getLWBridge(), railWayLW2.getLWBridge()));
        railWayLW.setLWTractionA(Utils.sumDbArray(railWayLW1.getLWTractionA(), railWayLW2.getLWTractionA()));
        railWayLW.setLWTractionB(Utils.sumDbArray(railWayLW1.getLWTractionB(), railWayLW2.getLWTractionB()));
        return railWayLW;
    }

    public static Double getDirectionAttenuation(TrainNoiseSource noiseSource, double phi, double theta, double frequency) {
        if (noiseSource == TrainNoiseSource.BRIDGE) {
            return 0.0;
        }
        theta = Math.min(Math.max(theta, -1.5707963267948966), 1.5707963267948966);
        phi = Math.max(0.0, Math.min(phi, Math.PI * 2));
        int height_index = TRAIN_NOISE_SOURCE_H_INDEX[noiseSource.ordinal()];
        double attHorizontal = 10.0 * Math.log10(0.01 + 0.99 * Math.pow(Math.sin(phi), 2.0));
        double attVertical = 0.0;
        if (height_index == 0) {
            if (theta > 0.0) {
                attVertical = 13.333333333333334 * (0.6666666666666666 * Math.sin(2.0 * theta) - Math.sin(theta)) * Math.log10((frequency + 600.0) / 200.0);
            }
        } else if (height_index == 1 && noiseSource == TrainNoiseSource.AERODYNAMICB && theta < 0.0) {
            attVertical = 10.0 * Math.log10(Math.pow(Math.cos(theta), 2.0));
        }
        return attHorizontal + attVertical;
    }

    public double[] getLWRolling() {
        return this.lWRolling;
    }

    public void setLWRolling(double[] LWRolling) {
        this.lWRolling = LWRolling;
    }

    public double[] getLWTractionA() {
        return this.lWTractionA;
    }

    public void setLWTractionA(double[] LWTractionA) {
        this.lWTractionA = LWTractionA;
    }

    public double[] getLWTractionB() {
        return this.lWTractionB;
    }

    public void setLWTractionB(double[] LWTractionB) {
        this.lWTractionB = LWTractionB;
    }

    public double[] getLWAerodynamicA() {
        return this.lWAerodynamicA;
    }

    public void setLWAerodynamicA(double[] LWAerodynamicA) {
        this.lWAerodynamicA = LWAerodynamicA;
    }

    public double[] getLWAerodynamicB() {
        return this.lWAerodynamicB;
    }

    public void setLWAerodynamicB(double[] LWAerodynamicB) {
        this.lWAerodynamicB = LWAerodynamicB;
    }

    public double[] getLWBridge() {
        return this.lWBridge;
    }

    public void setLWBridge(double[] LWBridge) {
        this.lWBridge = LWBridge;
    }

    public static enum TrainNoiseSource {
        ROLLING,
        TRACTIONA,
        TRACTIONB,
        AERODYNAMICA,
        AERODYNAMICB,
        BRIDGE;

    }
}

