/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway.nmpb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.noise_planet.noisemodelling.emission.railway.nmpb.RailWayNMPBParameters;
import org.noise_planet.noisemodelling.emission.railway.nmpb.RailwayTrackNMPBParameters;
import org.noise_planet.noisemodelling.emission.railway.nmpb.RailwayVehicleNMPBParameters;
import org.noise_planet.noisemodelling.emission.utils.interpLinear;

public class RailwayNMPB {
    private JsonNode NMPBRailWayData;
    private JsonNode NMPBRailWayData2020;
    private JsonNode NMPBRailWayDataSncf;
    private JsonNode NMPBVehicleData;
    private JsonNode NMPBTrainData;

    private static JsonNode parse(InputStream inputStream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(inputStream);
        }
        catch (IOException ex) {
            return NullNode.getInstance();
        }
    }

    public static <T> Iterable<T> iteratorToIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public void setEvaluateRailwaySourceNMPB(InputStream NMPBVehicleData, InputStream NMPBTrainData) {
        this.NMPBVehicleData = RailwayNMPB.parse(NMPBVehicleData);
        this.NMPBTrainData = RailwayNMPB.parse(NMPBTrainData);
    }

    public JsonNode getNMPBRailWayData(int fileVersion) {
        if (fileVersion == 1) {
            if (this.NMPBRailWayData2020 == null) {
                this.NMPBRailWayData2020 = RailwayNMPB.parse(RailwayNMPB.class.getResourceAsStream("RailwayNMPBEU_2020.json"));
            }
            return this.NMPBRailWayData2020;
        }
        if (fileVersion == 2) {
            if (this.NMPBRailWayDataSncf == null) {
                this.NMPBRailWayDataSncf = RailwayNMPB.parse(RailwayNMPB.class.getResourceAsStream("RailwayNMPBSNCF_2021.json"));
            }
            return this.NMPBRailWayDataSncf;
        }
        if (this.NMPBRailWayData == null) {
            this.NMPBRailWayData = RailwayNMPB.parse(RailwayNMPB.class.getResourceAsStream("RailwayNMPBSNCF_2021.json"));
        }
        return this.NMPBRailWayData;
    }

    public JsonNode getNMPBVehicleNode(String typeVehicle) {
        JsonNode vehicle = this.getNMPBVehicleData().get(typeVehicle);
        if (vehicle == null) {
            throw new IllegalArgumentException(String.format("Vehicle %s not found must be one of :\n -%s", typeVehicle, String.join((CharSequence)"\n -", RailwayNMPB.iteratorToIterable(this.getNMPBVehicleData().fieldNames()))));
        }
        return vehicle;
    }

    public JsonNode getNMPBVehicleData() {
        if (this.NMPBVehicleData == null) {
            this.NMPBVehicleData = RailwayNMPB.parse(RailwayNMPB.class.getResourceAsStream("RailwayVehiclesNMPB.json"));
        }
        return this.NMPBVehicleData;
    }

    public JsonNode getNMPBTrainData() {
        if (this.NMPBTrainData == null) {
            this.NMPBTrainData = RailwayNMPB.parse(RailwayNMPB.class.getResourceAsStream("RailwayTrainsets.json"));
        }
        return this.NMPBTrainData;
    }

    public Map<String, Integer> getVehicleFromTrain(String trainName) {
        Map vehicles = null;
        Iterator it = this.getNMPBTrainData().fields();
        while (it.hasNext()) {
            Map.Entry elt = (Map.Entry)it.next();
            if (!trainName.equals(elt.getKey())) continue;
            ObjectMapper mapper = new ObjectMapper();
            vehicles = (Map)mapper.convertValue(elt.getValue(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
            break;
        }
        return vehicles;
    }

    public boolean isInVehicleList(String vehicleName) {
        boolean inlist = false;
        Iterator it = this.getNMPBVehicleData().fields();
        while (it.hasNext()) {
            Map.Entry elt = (Map.Entry)it.next();
            if (!vehicleName.equals(elt.getKey())) continue;
            inlist = true;
            break;
        }
        return inlist;
    }

    public Double getLambdaValue(String typeVehicle, String refType, int spectreVer, int lambdaId) {
        int refId = this.getNMPBVehicleNode(typeVehicle).get(refType).intValue();
        String ref = "";
        if (refType.equals("RefRoughness")) {
            ref = "WheelRoughness";
        } else if (refType.equals("RefContact")) {
            ref = "ContactFilter";
        }
        return this.getNMPBRailWayData(spectreVer).get("Vehicle").get(ref).get(String.valueOf(refId)).get("Values").get(lambdaId).doubleValue();
    }

    public Double getTrackRoughness(int trackRoughnessId, int spectreVer, int lambdaId) {
        return this.getNMPBRailWayData(spectreVer).get("Track").get("RailRoughness").get(String.valueOf(trackRoughnessId)).get("Values").get(lambdaId).doubleValue();
    }

    public double getAxlesPerVeh(String typeVehicle) {
        return this.getNMPBVehicleNode(typeVehicle).get("NbAxlePerVeh").doubleValue();
    }

    public int getNbCoach(String typeVehicle) {
        int nbCoach;
        try {
            nbCoach = this.getNMPBVehicleData().get(typeVehicle).get("NbCoach").intValue();
        }
        catch (Exception e) {
            nbCoach = 1;
        }
        return nbCoach;
    }

    public double getSpectre(String typeVehicle, String ref, int runningCondition, String sourceHeight, int spectreVer, int freqId) {
        int refId = this.getNMPBVehicleNode(typeVehicle).get(ref).intValue();
        if (ref.equals("RefTraction")) {
            double tractionSpectre = 0.0;
            String condition = "ConstantSpeed";
            if (refId != 0) {
                switch (runningCondition) {
                    case 0: {
                        condition = "ConstantSpeed";
                        break;
                    }
                    case 1: {
                        condition = "AccelerationSpeed";
                        break;
                    }
                    case 3: {
                        condition = "DecelerationSpeed";
                        break;
                    }
                    case 4: {
                        condition = "IdlingSpeed";
                    }
                }
                try {
                    tractionSpectre = this.getNMPBRailWayData(spectreVer).get("Vehicle").get(condition).get(String.valueOf(refId)).get("Values").get(sourceHeight).get(freqId).doubleValue();
                }
                catch (NullPointerException ex) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find traction spectrum for the following parameters getNMPBRailWayData(%d).get(\"Vehicle\").get(%s).get(String.valueOf(%d)).get(\"Values\").get(%s).get(%d)", spectreVer, condition, refId, sourceHeight, freqId));
                }
            }
            return tractionSpectre;
        }
        if (ref.equals("RefAerodynamic")) {
            double aerodynamicNoise = this.getNMPBRailWayData(spectreVer).get("Vehicle").get("AerodynamicNoise").get(String.valueOf(refId)).get("Values").get(sourceHeight).get(freqId).doubleValue();
            return aerodynamicNoise;
        }
        return 0.0;
    }

    public double getAeroV0Alpha(String typeVehicle, String ref, int spectreVer, String aeroInf) {
        int refId = this.getNMPBVehicleNode(typeVehicle).get(ref).intValue();
        return Double.parseDouble(this.getNMPBRailWayData(spectreVer).get("Vehicle").get("AerodynamicNoise").get(String.valueOf(refId)).get(aeroInf).asText());
    }

    public Double getBridgeStructural(int bridgeId, int spectreVer, int freqId) {
        return this.getNMPBRailWayData(spectreVer).get("Track").get("BridgeConstant").get(String.valueOf(bridgeId)).get("Values").get(freqId).doubleValue();
    }

    public Double getTrackTransfer(int trackTransferId, int spectreVer, int freqId) {
        return this.getNMPBRailWayData(spectreVer).get("Track").get("TrackTransfer").get(String.valueOf(trackTransferId)).get("Spectre").get(freqId).doubleValue();
    }

    public Double getImpactNoise(int impactNoiseId, int spectreVer, int freqId) {
        return this.getNMPBRailWayData(spectreVer).get("Track").get("ImpactNoise").get(String.valueOf(impactNoiseId)).get("Values").get(freqId).doubleValue();
    }

    public Double getVehTransfer(String typeVehicle, int spectreVer, int freqId) {
        int RefTransfer = this.getNMPBVehicleNode(typeVehicle).get("RefTransfer").intValue();
        return this.getNMPBRailWayData(spectreVer).get("Vehicle").get("Transfer").get(String.valueOf(RefTransfer)).get("Spectre").get(freqId).doubleValue();
    }

    public Double getLRoughness(String typeVehicle, int trackRoughnessId, int spectreVer, int idLambda) {
        double wheelRoughness = this.getLambdaValue(typeVehicle, "RefRoughness", spectreVer, idLambda);
        double trackRoughness = this.getTrackRoughness(trackRoughnessId, spectreVer, idLambda);
        return 10.0 * Math.log10(Math.pow(10.0, wheelRoughness / 10.0) + Math.pow(10.0, trackRoughness / 10.0));
    }

    private double[] checkNanValue(double[] roughnessLtot) {
        int i;
        int indice_NaN = 0;
        for (i = 0; i < 24; ++i) {
            if (!Double.isNaN(roughnessLtot[i])) continue;
            ++indice_NaN;
        }
        for (i = 0; i < indice_NaN; ++i) {
            roughnessLtot[i] = roughnessLtot[indice_NaN + 1];
        }
        return roughnessLtot;
    }

    public RailWayNMPBParameters evaluate(RailwayVehicleNMPBParameters vehicleParameters, RailwayTrackNMPBParameters trackParameters) throws IOException {
        String fileVersion = "";
        String typeVehicle = vehicleParameters.getTypeVehicle();
        double speedVehicle = vehicleParameters.getSpeedVehicle();
        double vehPerHour = vehicleParameters.getNumberVehicle();
        double axlesPerVeh = this.getAxlesPerVeh(typeVehicle);
        int runningCondition = vehicleParameters.getRunningCondition();
        double speedTrack = trackParameters.getSpeedTrack();
        double speedCommercial = trackParameters.getSpeedCommercial();
        int trackRoughnessId = trackParameters.getRailRoughness();
        int trackTransferId = trackParameters.getTrackTransfer();
        int impactId = trackParameters.getImpactNoise();
        int bridgeId = trackParameters.getBridgeTransfert();
        int curvature = trackParameters.getCurvature();
        double speed = Math.min(speedVehicle, Math.min(speedTrack, speedCommercial));
        boolean isTunnel = trackParameters.getIsTunnel();
        double[] lWSpectre = new double[24];
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            lWSpectre[idFreq] = -99.0;
        }
        RailWayNMPBParameters lWRailWay = new RailWayNMPBParameters(lWSpectre, lWSpectre, lWSpectre, lWSpectre, lWSpectre, lWSpectre);
        return lWRailWay;
    }

    private double[] evaluateLWSpectre(String typeVehicle, String ref, int runningCondition, double speed, int height, int spectreVer) {
        double[] lWSpectre = new double[24];
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            if (!ref.equals("RefAerodynamic")) {
                if (height == 0) {
                    lWSpectre[idFreq] = this.getSpectre(typeVehicle, ref, runningCondition, "A", spectreVer, idFreq);
                    continue;
                }
                if (height != 1) continue;
                lWSpectre[idFreq] = this.getSpectre(typeVehicle, ref, runningCondition, "B", spectreVer, idFreq);
                continue;
            }
            int refId = this.getNMPBVehicleNode(typeVehicle).get(ref).intValue();
            if (speed < 200.0 || refId == 0) {
                lWSpectre[idFreq] = -99.0;
                continue;
            }
            if (height == 0) {
                lWSpectre[idFreq] = this.getSpectre(typeVehicle, ref, runningCondition, "A", spectreVer, idFreq);
            } else if (height == 1) {
                lWSpectre[idFreq] = this.getSpectre(typeVehicle, ref, runningCondition, "B", spectreVer, idFreq);
            }
            double v0Aero = this.getAeroV0Alpha(typeVehicle, ref, spectreVer, "V0");
            double alphaAero = this.getAeroV0Alpha(typeVehicle, ref, spectreVer, "Alpha");
            lWSpectre[idFreq] = lWSpectre[idFreq] + alphaAero * Math.log10(speed / v0Aero);
        }
        return lWSpectre;
    }

    private double[] evaluateLWroughness(String ref, String typeVehicle, int trackRoughnessId, int impactId, int bridgeId, int curvature, double speed, int trackTransferId, int spectreVer, double axlesPerVeh) {
        double[] lW;
        block7: {
            int idFreq;
            double[] roughnessLtot;
            block6: {
                double[] trackTransfer = new double[24];
                double[] lWTr = new double[24];
                double[] vehTransfer = new double[24];
                double[] lWVeh = new double[24];
                lW = new double[24];
                roughnessLtot = this.checkNanValue(this.evaluateRoughnessLtotFreq(typeVehicle, trackRoughnessId, impactId, speed, spectreVer));
                if (!ref.equals("Rolling")) break block6;
                for (int idFreq2 = 0; idFreq2 < 24; ++idFreq2) {
                    trackTransfer[idFreq2] = this.getTrackTransfer(trackTransferId, spectreVer, idFreq2);
                    lWTr[idFreq2] = roughnessLtot[idFreq2] + trackTransfer[idFreq2] + 10.0 * Math.log10(axlesPerVeh);
                    vehTransfer[idFreq2] = this.getVehTransfer(typeVehicle, spectreVer, idFreq2);
                    lWVeh[idFreq2] = roughnessLtot[idFreq2] + vehTransfer[idFreq2] + 10.0 * Math.log10(axlesPerVeh);
                    lW[idFreq2] = 10.0 * Math.log10(Math.pow(10.0, lWTr[idFreq2] / 10.0) + Math.pow(10.0, lWVeh[idFreq2] / 10.0));
                    if (curvature == 1) {
                        lW[idFreq2] = lW[idFreq2] + 5.0;
                        continue;
                    }
                    if (curvature == 2) {
                        lW[idFreq2] = lW[idFreq2] + 8.0;
                        continue;
                    }
                    if (curvature != 3) continue;
                    lW[idFreq2] = lW[idFreq2] + 8.0;
                }
                break block7;
            }
            if (!ref.equals("Bridge")) break block7;
            double[] lWBridge = new double[24];
            for (idFreq = 0; idFreq < 24; ++idFreq) {
                lW[idFreq] = -99.0;
            }
            if (spectreVer == 1 && (bridgeId == 3 || bridgeId == 4)) {
                for (idFreq = 0; idFreq < 24; ++idFreq) {
                    lWBridge[idFreq] = this.getBridgeStructural(bridgeId, spectreVer, idFreq);
                    lW[idFreq] = roughnessLtot[idFreq] + lWBridge[idFreq] + 10.0 * Math.log10(axlesPerVeh);
                }
            }
        }
        return lW;
    }

    private double[] evaluateRoughnessLtotFreq(String typeVehicle, int trackRoughnessId, int impactId, double speed, int spectreVer) {
        double[] roughnessTotLambda = new double[35];
        double[] roughnessLtot = new double[35];
        double[] contactFilter = new double[35];
        double[] lambdaToFreqLog = new double[35];
        double[] freqMedLog = new double[24];
        double[] Lambda = new double[35];
        double m = 33.0;
        for (int idLambda = 0; idLambda < 35; ++idLambda) {
            Lambda[idLambda] = Math.pow(10.0, m / 10.0);
            lambdaToFreqLog[idLambda] = Math.log10(speed / Lambda[idLambda] * 1000.0 / 3.6);
            roughnessTotLambda[idLambda] = Math.pow(10.0, this.getLRoughness(typeVehicle, trackRoughnessId, spectreVer, idLambda) / 10.0);
            if (impactId != 0) {
                roughnessTotLambda[idLambda] = roughnessTotLambda[idLambda] + Math.pow(10.0, this.getImpactNoise(impactId, spectreVer, idLambda) / 10.0);
            }
            contactFilter[idLambda] = this.getLambdaValue(typeVehicle, "RefContact", spectreVer, idLambda);
            roughnessLtot[idLambda] = 10.0 * Math.log10(roughnessTotLambda[idLambda]) + contactFilter[idLambda];
            roughnessLtot[idLambda] = Math.pow(10.0, roughnessLtot[idLambda] / 10.0);
            m -= 1.0;
        }
        for (int idFreqMed = 0; idFreqMed < 24; ++idFreqMed) {
            freqMedLog[idFreqMed] = Math.log10(Math.pow(10.0, (17.0 + Double.valueOf(idFreqMed)) / 10.0));
        }
        double[] roughnessLtotFreq = interpLinear.interpLinear(lambdaToFreqLog, roughnessLtot, freqMedLog);
        for (int idRoughnessLtotFreq = 0; idRoughnessLtotFreq < 24; ++idRoughnessLtotFreq) {
            roughnessLtotFreq[idRoughnessLtotFreq] = 10.0 * Math.log10(roughnessLtotFreq[idRoughnessLtotFreq]);
        }
        return roughnessLtotFreq;
    }
}

