/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.road.cnossos;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import org.noise_planet.noisemodelling.emission.road.cnossos.RoadCnossosParameters;
import org.noise_planet.noisemodelling.emission.utils.Utils;

public class RoadCnossos {
    private static JsonNode RoadCnossos_2015 = RoadCnossos.parse(RoadCnossos.class.getResourceAsStream("RoadCnossos_2015.json"));
    private static JsonNode cnossosData2020 = RoadCnossos.parse(RoadCnossos.class.getResourceAsStream("RoadCnossos_2020.json"));

    private static JsonNode parse(InputStream inputStream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(inputStream);
        }
        catch (IOException ex) {
            return NullNode.getInstance();
        }
    }

    public static JsonNode getCnossosData(int fileVersion) {
        if (fileVersion == 1) {
            return RoadCnossos_2015;
        }
        return cnossosData2020;
    }

    public static Double getA_RoadSurfaceCoeff(int Freq, String vehCat, String roadSurface, int fileVersion) throws IOException {
        int Freq_ind;
        switch (Freq) {
            case 63: {
                Freq_ind = 0;
                break;
            }
            case 125: {
                Freq_ind = 1;
                break;
            }
            case 250: {
                Freq_ind = 2;
                break;
            }
            case 500: {
                Freq_ind = 3;
                break;
            }
            case 1000: {
                Freq_ind = 4;
                break;
            }
            case 2000: {
                Freq_ind = 5;
                break;
            }
            case 4000: {
                Freq_ind = 6;
                break;
            }
            case 8000: {
                Freq_ind = 7;
                break;
            }
            default: {
                Freq_ind = 0;
            }
        }
        if (RoadCnossos.getCnossosData(fileVersion).get("roads").get(roadSurface) == null) {
            throw new IOException("Error : the pavement " + roadSurface + " doesn't exist in the database.");
        }
        return RoadCnossos.getCnossosData(fileVersion).get("roads").get(roadSurface).get("ref").get(vehCat).get("spectrum").get(Freq_ind).doubleValue();
    }

    public static Double getB_RoadSurfaceCoeff(String vehCat, String roadSurface, int fileVersion) {
        return RoadCnossos.getCnossosData(fileVersion).get("roads").get(roadSurface).get("ref").get(vehCat).get("\u00dfm").doubleValue();
    }

    public static double getCr(String vehCat, int k, int fileVersion) {
        return RoadCnossos.getCnossosData(fileVersion).get("vehicles").get(vehCat).get(k == 1 ? "crossing" : "roundabout").get("cr").doubleValue();
    }

    public static double getCp(String vehCat, int k, int fileVersion) {
        return RoadCnossos.getCnossosData(fileVersion).get("vehicles").get(vehCat).get(k == 1 ? "crossing" : "roundabout").get("cp").doubleValue();
    }

    public static Double getCoeff(String coeff, int freq, String vehicleCategory, int coeffVer) {
        int Freq_ind;
        switch (freq) {
            case 63: {
                Freq_ind = 0;
                break;
            }
            case 125: {
                Freq_ind = 1;
                break;
            }
            case 250: {
                Freq_ind = 2;
                break;
            }
            case 500: {
                Freq_ind = 3;
                break;
            }
            case 1000: {
                Freq_ind = 4;
                break;
            }
            case 2000: {
                Freq_ind = 5;
                break;
            }
            case 4000: {
                Freq_ind = 6;
                break;
            }
            case 8000: {
                Freq_ind = 7;
                break;
            }
            default: {
                Freq_ind = 0;
            }
        }
        return RoadCnossos.getCnossosData(coeffVer).get("vehicles").get(vehicleCategory).get(coeff).get(Freq_ind).doubleValue();
    }

    public static Double getNoiseLvl(double base, double adj, double speed, double speedBase) {
        return base + adj * Math.log10(speed / speedBase);
    }

    private static Double getDeltaStuddedTyres(RoadCnossosParameters roadCnossosParameters, double Pm_stud, double Ts_stud, int freq, int fileVersion, double vRef) throws IOException {
        double speed = roadCnossosParameters.getSpeedLv();
        double ps = Pm_stud * Ts_stud / 12.0;
        speed = speed >= 90.0 ? 90.0 : speed;
        speed = speed <= 50.0 ? 50.0 : speed;
        double deltastud = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("a", freq, "1", fileVersion), RoadCnossos.getCoeff("b", freq, "1", fileVersion), speed, vRef);
        return 10.0 * Math.log10(1.0 - ps + ps * Math.pow(10.0, deltastud / 10.0));
    }

    private static Double getDeltaTemperature(double Temperature, String vehicleCategory) {
        double K = 0.08;
        double tempRef = 20.0;
        switch (vehicleCategory) {
            case "1": {
                K = 0.08;
                break;
            }
            case "2": {
                K = 0.04;
                break;
            }
            case "3": {
                K = 0.04;
            }
        }
        return K * (tempRef - Temperature);
    }

    private static Double getDeltaSlope(RoadCnossosParameters roadCnossosParameters, String vehicleCategory, double slopeDirection) throws IOException {
        double deltaSlope = 0.0;
        double slope = slopeDirection * roadCnossosParameters.getSlopePercentage();
        switch (vehicleCategory) {
            case "1": {
                if (slope < -6.0) {
                    deltaSlope = Math.min(12.0, -slope) - 6.0;
                    break;
                }
                if (slope <= 2.0) {
                    deltaSlope = 0.0;
                    break;
                }
                deltaSlope = roadCnossosParameters.getSpeedLv() / 100.0 * ((Math.min(12.0, slope) - 2.0) / 1.5);
                break;
            }
            case "2": {
                if (slope < -4.0) {
                    deltaSlope = (roadCnossosParameters.getSpeedMv() - 20.0) / 100.0 * (Math.min(12.0, -slope) - 4.0) / 0.7;
                    break;
                }
                if (slope <= 0.0) {
                    deltaSlope = 0.0;
                    break;
                }
                deltaSlope = roadCnossosParameters.getSpeedMv() / 100.0 * Math.min(12.0, slope);
                break;
            }
            case "3": {
                if (slope < -4.0) {
                    deltaSlope = (roadCnossosParameters.getSpeedHgv() - 10.0) / 100.0 * (Math.min(12.0, -slope) - 4.0) / 0.5;
                    break;
                }
                if (slope <= 0.0) {
                    deltaSlope += 0.0;
                    break;
                }
                deltaSlope += roadCnossosParameters.getSpeedHgv() / 100.0 * Math.min(12.0, slope) / 0.8;
            }
        }
        return deltaSlope;
    }

    public static double evaluate(RoadCnossosParameters roadCnossosParameters) throws IOException {
        int freqParam = roadCnossosParameters.getFrequency();
        double Temperature = roadCnossosParameters.getTemperature();
        double Ts_stud = roadCnossosParameters.getTsStud();
        double Pm_stud = roadCnossosParameters.getqStudRatio();
        double Junc_dist = roadCnossosParameters.getJunc_dist();
        int Junc_type = roadCnossosParameters.getJunc_type();
        String roadSurface = roadCnossosParameters.getRoadSurface();
        int coeffVer = roadCnossosParameters.getFileVersion();
        double vRef = 70.0;
        double lvRoadLvl = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("ar", freqParam, "1", coeffVer), RoadCnossos.getCoeff("br", freqParam, "1", coeffVer), roadCnossosParameters.getSpeedLv(), vRef);
        double medRoadLvl = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("ar", freqParam, "2", coeffVer), RoadCnossos.getCoeff("br", freqParam, "2", coeffVer), roadCnossosParameters.getSpeedMv(), vRef);
        double hgvRoadLvl = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("ar", freqParam, "3", coeffVer), RoadCnossos.getCoeff("br", freqParam, "3", coeffVer), roadCnossosParameters.getSpeedHgv(), vRef);
        if (Pm_stud > 0.0 && Ts_stud > 0.0) {
            lvRoadLvl += RoadCnossos.getDeltaStuddedTyres(roadCnossosParameters, Pm_stud, Ts_stud, freqParam, coeffVer, vRef).doubleValue();
        }
        lvRoadLvl += RoadCnossos.getDeltaTemperature(Temperature, "1").doubleValue();
        medRoadLvl += RoadCnossos.getDeltaTemperature(Temperature, "2").doubleValue();
        hgvRoadLvl += RoadCnossos.getDeltaTemperature(Temperature, "3").doubleValue();
        double lvMotorLvl = RoadCnossos.getCoeff("ap", freqParam, "1", coeffVer) + RoadCnossos.getCoeff("bp", freqParam, "1", coeffVer) * (roadCnossosParameters.getSpeedLv() - vRef) / vRef;
        double medMotorLvl = RoadCnossos.getCoeff("ap", freqParam, "2", coeffVer) + RoadCnossos.getCoeff("bp", freqParam, "2", coeffVer) * (roadCnossosParameters.getSpeedMv() - vRef) / vRef;
        double hgvMotorLvl = RoadCnossos.getCoeff("ap", freqParam, "3", coeffVer) + RoadCnossos.getCoeff("bp", freqParam, "3", coeffVer) * (roadCnossosParameters.getSpeedHgv() - vRef) / vRef;
        double wheelaMotorLvl = RoadCnossos.getCoeff("ap", freqParam, "4a", coeffVer) + RoadCnossos.getCoeff("bp", freqParam, "4a", coeffVer) * (roadCnossosParameters.getSpeedWav() - vRef) / vRef;
        double wheelbMotorLvl = RoadCnossos.getCoeff("ap", freqParam, "4b", coeffVer) + RoadCnossos.getCoeff("bp", freqParam, "4b", coeffVer) * (roadCnossosParameters.getSpeedWbv() - vRef) / vRef;
        double sign = 1.0;
        boolean twoWay = false;
        switch ((int)roadCnossosParameters.getWay()) {
            case 1: {
                sign = 1.0;
                break;
            }
            case 2: {
                sign = -1.0;
                break;
            }
            case 3: {
                twoWay = true;
            }
        }
        lvMotorLvl += RoadCnossos.getDeltaSlope(roadCnossosParameters, "1", sign).doubleValue();
        medMotorLvl += RoadCnossos.getDeltaSlope(roadCnossosParameters, "2", sign).doubleValue();
        hgvMotorLvl += RoadCnossos.getDeltaSlope(roadCnossosParameters, "3", sign).doubleValue();
        double coefficientJunctionDistance = Math.max(1.0 - Math.abs(Junc_dist) / 100.0, 0.0);
        lvRoadLvl += RoadCnossos.getCr("1", Junc_type, coeffVer) * coefficientJunctionDistance;
        medRoadLvl += RoadCnossos.getCr("2", Junc_type, coeffVer) * coefficientJunctionDistance;
        hgvRoadLvl += RoadCnossos.getCr("3", Junc_type, coeffVer) * coefficientJunctionDistance;
        lvMotorLvl += RoadCnossos.getCp("1", Junc_type, coeffVer) * coefficientJunctionDistance;
        medMotorLvl += RoadCnossos.getCp("2", Junc_type, coeffVer) * coefficientJunctionDistance;
        hgvMotorLvl += RoadCnossos.getCp("3", Junc_type, coeffVer) * coefficientJunctionDistance;
        wheelaMotorLvl += RoadCnossos.getCp("4a", Junc_type, coeffVer) * coefficientJunctionDistance;
        wheelbMotorLvl += RoadCnossos.getCp("4b", Junc_type, coeffVer) * coefficientJunctionDistance;
        double lvCompound = Utils.sumDbValues(lvRoadLvl += RoadCnossos.getNoiseLvl(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "1", roadCnossosParameters.getRoadSurface(), coeffVer), RoadCnossos.getB_RoadSurfaceCoeff("1", roadSurface, coeffVer), roadCnossosParameters.getSpeedLv(), 70.0).doubleValue(), lvMotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "1", roadSurface, coeffVer), 0.0));
        double medCompound = Utils.sumDbValues(medRoadLvl += RoadCnossos.getNoiseLvl(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "2", roadCnossosParameters.getRoadSurface(), coeffVer), RoadCnossos.getB_RoadSurfaceCoeff("2", roadSurface, coeffVer), roadCnossosParameters.getSpeedMv(), 70.0).doubleValue(), medMotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "2", roadSurface, coeffVer), 0.0));
        double hgvCompound = Utils.sumDbValues(hgvRoadLvl += RoadCnossos.getNoiseLvl(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "3", roadCnossosParameters.getRoadSurface(), coeffVer), RoadCnossos.getB_RoadSurfaceCoeff("3", roadSurface, coeffVer), roadCnossosParameters.getSpeedHgv(), 70.0).doubleValue(), hgvMotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "3", roadSurface, coeffVer), 0.0));
        double wheelaCompound = wheelaMotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "4a", roadSurface, coeffVer), 0.0);
        double wheelbCompound = wheelbMotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, "4b", roadSurface, coeffVer), 0.0);
        double lvLvl = Utils.Vperhour2NoiseLevel(lvCompound, roadCnossosParameters.getLvPerHour(), roadCnossosParameters.getSpeedLv());
        double medLvl = Utils.Vperhour2NoiseLevel(medCompound, roadCnossosParameters.getMvPerHour(), roadCnossosParameters.getSpeedMv());
        double hgvLvl = Utils.Vperhour2NoiseLevel(hgvCompound, roadCnossosParameters.getHgvPerHour(), roadCnossosParameters.getSpeedHgv());
        double wheelaLvl = Utils.Vperhour2NoiseLevel(wheelaCompound, roadCnossosParameters.getWavPerHour(), roadCnossosParameters.getSpeedWav());
        double wheelbLvl = Utils.Vperhour2NoiseLevel(wheelbCompound, roadCnossosParameters.getWbvPerHour(), roadCnossosParameters.getSpeedWbv());
        if (twoWay && roadCnossosParameters.getSlopePercentage() != 0.0) {
            lvRoadLvl = lvRoadLvl - RoadCnossos.getDeltaSlope(roadCnossosParameters, "1", sign) + RoadCnossos.getDeltaSlope(roadCnossosParameters, "1", -sign);
            medRoadLvl = medRoadLvl - RoadCnossos.getDeltaSlope(roadCnossosParameters, "2", sign) + RoadCnossos.getDeltaSlope(roadCnossosParameters, "2", -sign);
            hgvRoadLvl = hgvRoadLvl - RoadCnossos.getDeltaSlope(roadCnossosParameters, "3", sign) + RoadCnossos.getDeltaSlope(roadCnossosParameters, "3", -sign);
            double lvCompound_InverseSlope = Utils.sumDbValues(lvRoadLvl, lvMotorLvl);
            double medCompound_InverseSlope = Utils.sumDbValues(medRoadLvl, medMotorLvl);
            double hgvCompound_InverseSlope = Utils.sumDbValues(hgvRoadLvl, hgvMotorLvl);
            lvLvl = Utils.sumDbValues(Utils.Vperhour2NoiseLevel(lvCompound, roadCnossosParameters.getLvPerHour() / 2.0, roadCnossosParameters.getSpeedLv()), Utils.Vperhour2NoiseLevel(lvCompound_InverseSlope, roadCnossosParameters.getLvPerHour() / 2.0, roadCnossosParameters.getSpeedLv()));
            medLvl = Utils.sumDbValues(Utils.Vperhour2NoiseLevel(medCompound, roadCnossosParameters.getMvPerHour() / 2.0, roadCnossosParameters.getSpeedMv()), Utils.Vperhour2NoiseLevel(medCompound_InverseSlope, roadCnossosParameters.getMvPerHour() / 2.0, roadCnossosParameters.getSpeedMv()));
            hgvLvl = Utils.sumDbValues(Utils.Vperhour2NoiseLevel(hgvCompound, roadCnossosParameters.getHgvPerHour() / 2.0, roadCnossosParameters.getSpeedHgv()), Utils.Vperhour2NoiseLevel(hgvCompound_InverseSlope, roadCnossosParameters.getHgvPerHour() / 2.0, roadCnossosParameters.getSpeedHgv()));
        }
        return Utils.sumDb5(lvLvl, medLvl, hgvLvl, wheelaLvl, wheelbLvl);
    }
}

