/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.utils;

import java.io.IOException;

public class Utils {
    public static double dbToW(double dB) {
        return Math.pow(10.0, dB / 10.0);
    }

    public static double wToDb(double w) {
        return 10.0 * Math.log10(w);
    }

    public static double computeSlope(double beginZ, double endZ, double road_length_2d) {
        return (endZ - beginZ) / road_length_2d * 100.0;
    }

    public static Double Vperhour2NoiseLevel(double LWim, double Qm, double vm) throws IOException {
        if (vm < 0.0) {
            throw new IOException("Error : speed < 0 km/h");
        }
        return LWim + 10.0 * Math.log10(Qm / (1000.0 * vm));
    }

    public static double[] Vperhour2NoiseLevelAllFreq(double[] LWimf, double Qm, double vm) throws IOException {
        double[] LWimf_return = new double[LWimf.length];
        if (vm < 0.0) {
            throw new IOException("Error : speed < 0 km/h");
        }
        for (int f = 1; f < LWimf.length; ++f) {
            LWimf_return[f] = LWimf[f] + 10.0 * Math.log10(Qm / (1000.0 * vm));
        }
        return LWimf_return;
    }

    public static double[] sumDbArray(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Not same size array");
        }
        double[] sum = new double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            sum[i] = Utils.wToDba(Utils.dbaToW(array1[i]) + Utils.dbaToW(array2[i]));
        }
        return sum;
    }

    public static double dbaToW(double dBA) {
        return Math.pow(10.0, dBA / 10.0);
    }

    public static double[] dbaToW(double[] dBA) {
        double[] ret = new double[dBA.length];
        for (int i = 0; i < dBA.length; ++i) {
            ret[i] = Utils.dbaToW(dBA[i]);
        }
        return ret;
    }

    public static double wToDba(double w) {
        return 10.0 * Math.log10(w);
    }

    public static double[] wToDba(double[] w) {
        double[] ret = new double[w.length];
        for (int i = 0; i < w.length; ++i) {
            ret[i] = Utils.wToDba(w[i]);
        }
        return ret;
    }

    public static Double sumDbValues(Double dB1, Double dB2) {
        return Utils.wToDb(Utils.dbToW(dB1) + Utils.dbToW(dB2));
    }

    public static Double sumDb5(Double dB1, Double dB2, Double dB3, Double dB4, Double dB5) {
        return Utils.wToDb(Utils.dbToW(dB1) + Utils.dbToW(dB2) + Utils.dbToW(dB3) + Utils.dbToW(dB4) + Utils.dbToW(dB5));
    }

    public static double[] trainLWmperFreq(double[] LWi, double nBUnit, double deltaT) throws IOException {
        double[] LW = new double[LWi.length];
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            LW[idFreq] = 10.0 * Math.log10(Math.pow(10.0, (LWi[idFreq] + 10.0 * Math.log10(nBUnit) + deltaT) / 10.0));
        }
        return LW;
    }
}

