/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.h2gis.functions.spatial.convert.ST_Force3D;
import org.h2gis.functions.spatial.edit.ST_UpdateZ;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.noise_planet.noisemodelling.emission.LineSource;
import org.noise_planet.noisemodelling.emission.railway.RailWayParameters;
import org.noise_planet.noisemodelling.emission.road.cnossos.RoadCnossos;
import org.noise_planet.noisemodelling.emission.road.cnossos.RoadCnossosParameters;
import org.noise_planet.noisemodelling.emission.utils.Utils;
import org.noise_planet.noisemodelling.jdbc.railway.RailWayLWGeom;
import org.noise_planet.noisemodelling.jdbc.railway.RailWayLWIterator;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;

public class EmissionTableGenerator {
    public static final List<Integer> roadOctaveFrequencyBands = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((int[])ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE));
    public static final String DEN_PERIOD = "DEN";
    public static final String[] STANDARD_PERIOD_VALUE = new String[]{"D", "E", "N"};
    public static final double DAY_RATIO = 0.5;
    public static final double EVENING_RATIO = 0.16666666666666666 * AcousticIndicatorsFunctions.dBToW((double)5.0);
    public static final double NIGHT_RATIO = 0.3333333333333333 * AcousticIndicatorsFunctions.dBToW((double)10.0);
    public static final double[] RATIOS = new double[]{0.5, EVENING_RATIO, NIGHT_RATIO};

    public static void cacheFields(Map<String, Integer> sourceFieldsCache, ResultSet rs) throws SQLException {
        if (sourceFieldsCache.isEmpty()) {
            int fieldId = 1;
            for (String fieldName : JDBCUtilities.getColumnNames((ResultSetMetaData)rs.getMetaData())) {
                sourceFieldsCache.put(fieldName.toUpperCase(), fieldId++);
            }
        }
    }

    public static double[] getEmissionFromTrafficTable(ResultSet rs, String period, double slope, int coefficientVersion, Map<String, Integer> sourceFieldsCache) throws SQLException {
        EmissionTableGenerator.cacheFields(sourceFieldsCache, rs);
        double tv = 0.0;
        double hv = 0.0;
        double lv_speed = 0.0;
        double mv_speed = 0.0;
        double hgv_speed = 0.0;
        double wav_speed = 0.0;
        double wbv_speed = 0.0;
        double lvPerHour = 0.0;
        double mvPerHour = 0.0;
        double hgvPerHour = 0.0;
        double wavPerHour = 0.0;
        double wbvPerHour = 0.0;
        double temperature = 20.0;
        String roadSurface = "NL08";
        double tsStud = 0.0;
        double pmStud = 0.0;
        double junctionDistance = 100.0;
        int junctionType = 2;
        int way = 3;
        if (sourceFieldsCache.containsKey("LV_SPD" + period)) {
            lv_speed = rs.getDouble(sourceFieldsCache.get("LV_SPD" + period));
        }
        if (sourceFieldsCache.containsKey("MV_SPD" + period)) {
            mv_speed = rs.getDouble(sourceFieldsCache.get("MV_SPD" + period));
        }
        if (sourceFieldsCache.containsKey("HGV_SPD" + period)) {
            hgv_speed = rs.getDouble(sourceFieldsCache.get("HGV_SPD" + period));
        }
        if (sourceFieldsCache.containsKey("WAV_SPD" + period)) {
            wav_speed = rs.getDouble(sourceFieldsCache.get("WAV_SPD" + period));
        }
        if (sourceFieldsCache.containsKey("WBV_SPD" + period)) {
            wbv_speed = rs.getDouble(sourceFieldsCache.get("WBV_SPD" + period));
        }
        if (sourceFieldsCache.containsKey("LV" + period)) {
            lvPerHour = rs.getDouble(sourceFieldsCache.get("LV" + period));
        }
        if (sourceFieldsCache.containsKey("MV" + period)) {
            mvPerHour = rs.getDouble(sourceFieldsCache.get("MV" + period));
        }
        if (sourceFieldsCache.containsKey("HGV" + period)) {
            hgvPerHour = rs.getDouble(sourceFieldsCache.get("HGV" + period));
        }
        if (sourceFieldsCache.containsKey("WAV" + period)) {
            wavPerHour = rs.getDouble(sourceFieldsCache.get("WAV" + period));
        }
        if (sourceFieldsCache.containsKey("WBV" + period)) {
            wbvPerHour = rs.getDouble(sourceFieldsCache.get("WBV" + period));
        }
        if (sourceFieldsCache.containsKey("PVMT")) {
            roadSurface = rs.getString(sourceFieldsCache.get("PVMT"));
        }
        if (sourceFieldsCache.containsKey("TEMP" + period)) {
            temperature = rs.getDouble(sourceFieldsCache.get("TEMP" + period));
        }
        if (sourceFieldsCache.containsKey("TS_STUD")) {
            tsStud = rs.getDouble(sourceFieldsCache.get("TS_STUD"));
        }
        if (sourceFieldsCache.containsKey("PM_STUD")) {
            pmStud = rs.getDouble(sourceFieldsCache.get("PM_STUD"));
        }
        if (sourceFieldsCache.containsKey("JUNC_DIST")) {
            junctionDistance = rs.getDouble(sourceFieldsCache.get("JUNC_DIST"));
        }
        if (sourceFieldsCache.containsKey("JUNC_TYPE")) {
            junctionType = rs.getInt(sourceFieldsCache.get("JUNC_TYPE"));
        }
        if (sourceFieldsCache.containsKey("WAY")) {
            way = rs.getInt(sourceFieldsCache.get("WAY"));
        }
        if (sourceFieldsCache.containsKey("SLOPE")) {
            slope = rs.getDouble(sourceFieldsCache.get("SLOPE"));
        } else {
            way = 3;
        }
        if (sourceFieldsCache.containsKey("TV" + period)) {
            tv = rs.getDouble(sourceFieldsCache.get("TV" + period));
        }
        if (sourceFieldsCache.containsKey("HV" + period)) {
            hv = rs.getDouble(sourceFieldsCache.get("HV" + period));
        }
        if (sourceFieldsCache.containsKey("HV_SPD" + period)) {
            hgv_speed = rs.getDouble(sourceFieldsCache.get("HV_SPD" + period));
        }
        if (tv > 0.0) {
            lvPerHour = tv - (hv + mvPerHour + hgvPerHour + wavPerHour + wbvPerHour);
        }
        if (hv > 0.0) {
            hgvPerHour = hv;
        }
        double[] lvl = new double[roadOctaveFrequencyBands.size()];
        for (int idFreq = 0; idFreq < roadOctaveFrequencyBands.size(); ++idFreq) {
            int freq = roadOctaveFrequencyBands.get(idFreq);
            RoadCnossosParameters rsParametersCnossos = new RoadCnossosParameters(lv_speed, mv_speed, hgv_speed, wav_speed, wbv_speed, lvPerHour, mvPerHour, hgvPerHour, wavPerHour, wbvPerHour, freq, temperature, roadSurface, tsStud, pmStud, junctionDistance, junctionType);
            rsParametersCnossos.setSlopePercentage(slope);
            rsParametersCnossos.setWay(way);
            rsParametersCnossos.setFileVersion(coefficientVersion);
            try {
                lvl[idFreq] = RoadCnossos.evaluate((RoadCnossosParameters)rsParametersCnossos);
                continue;
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
        return lvl;
    }

    public static double[][] computeLw(SpatialResultSet rs, int coefficientVersion, Map<String, Integer> sourceFieldsCache) throws SQLException {
        double slope = EmissionTableGenerator.getSlope(rs);
        double[] ld = AcousticIndicatorsFunctions.dBToW((double[])EmissionTableGenerator.getEmissionFromTrafficTable((ResultSet)rs, "_D", slope, coefficientVersion, sourceFieldsCache));
        double[] le = AcousticIndicatorsFunctions.dBToW((double[])EmissionTableGenerator.getEmissionFromTrafficTable((ResultSet)rs, "_E", slope, coefficientVersion, sourceFieldsCache));
        double[] ln = AcousticIndicatorsFunctions.dBToW((double[])EmissionTableGenerator.getEmissionFromTrafficTable((ResultSet)rs, "_N", slope, coefficientVersion, sourceFieldsCache));
        return new double[][]{ld, le, ln};
    }

    public static double getSlope(SpatialResultSet rs) {
        double slope = 0.0;
        try {
            Coordinate[] c;
            Geometry g = rs.getGeometry();
            if (g != null && !g.isEmpty() && (c = g.getCoordinates()).length >= 2) {
                double z0 = c[0].z;
                double z1 = c[1].z;
                if (!Double.isNaN(z0) && !Double.isNaN(z1)) {
                    slope = Utils.computeSlope((double)z0, (double)z1, (double)g.getLength());
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return slope;
    }

    public static double getSlope(Geometry g) {
        Coordinate[] c;
        double slope = 0.0;
        if (g != null && !g.isEmpty() && (c = g.getCoordinates()).length >= 2) {
            double z0 = c[0].z;
            double z1 = c[1].z;
            if (!Double.isNaN(z0) && !Double.isNaN(z1)) {
                slope = Utils.computeSlope((double)z0, (double)z1, (double)g.getLength());
            }
        }
        return slope;
    }

    public static void makeTrainLWTable(Connection connection, String railSectionTableName, String railTrafficTableName, String outputTable, String frequencyPrepend) throws SQLException {
        connection.createStatement().execute("drop table if exists " + outputTable);
        StringBuilder createTableQuery = new StringBuilder("create table " + outputTable + " (PK_SECTION int, the_geom GEOMETRY, DIR_ID int, GS double");
        StringBuilder insertIntoQuery = new StringBuilder("INSERT INTO " + outputTable + "(PK_SECTION, the_geom, DIR_ID, GS");
        StringBuilder insertIntoValuesQuery = new StringBuilder("?,?,?,?");
        for (int thirdOctave : ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE) {
            createTableQuery.append(", ").append(frequencyPrepend).append("D");
            createTableQuery.append(thirdOctave);
            createTableQuery.append(" double precision");
            insertIntoQuery.append(", ").append(frequencyPrepend).append("D");
            insertIntoQuery.append(thirdOctave);
            insertIntoValuesQuery.append(", ?");
        }
        for (int thirdOctave : ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE) {
            createTableQuery.append(", ").append(frequencyPrepend).append("E");
            createTableQuery.append(thirdOctave);
            createTableQuery.append(" double precision");
            insertIntoQuery.append(", ").append(frequencyPrepend).append("E");
            insertIntoQuery.append(thirdOctave);
            insertIntoValuesQuery.append(", ?");
        }
        for (int thirdOctave : ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE) {
            createTableQuery.append(", ").append(frequencyPrepend).append("N");
            createTableQuery.append(thirdOctave);
            createTableQuery.append(" double precision");
            insertIntoQuery.append(", ").append(frequencyPrepend).append("N");
            insertIntoQuery.append(thirdOctave);
            insertIntoValuesQuery.append(", ?");
        }
        createTableQuery.append(")");
        insertIntoQuery.append(") VALUES (");
        insertIntoQuery.append((CharSequence)insertIntoValuesQuery);
        insertIntoQuery.append(")");
        connection.createStatement().execute(createTableQuery.toString());
        RailWayLWIterator railWayLWIterator = new RailWayLWIterator(connection, railSectionTableName, railTrafficTableName);
        while (railWayLWIterator.hasNext()) {
            RailWayLWGeom railWayLWGeom = railWayLWIterator.next();
            RailWayParameters railWayLWDay = railWayLWGeom.getRailWayLWDay();
            RailWayParameters railWayLWEvening = railWayLWGeom.getRailWayLWEvening();
            RailWayParameters railWayLWNight = railWayLWGeom.getRailWayLWNight();
            List<LineString> geometries = railWayLWGeom.getRailWayLWGeometry();
            int pk = railWayLWGeom.getPK();
            double[] LWDay = new double[ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
            double[] LWEvening = new double[ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
            double[] LWNight = new double[ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE.length];
            Arrays.fill(LWDay, -99.0);
            Arrays.fill(LWEvening, -99.0);
            Arrays.fill(LWNight, -99.0);
            double heightSource = 0.0;
            int directivityId = 0;
            boolean day = !railWayLWDay.getRailwaySourceList().isEmpty();
            boolean evening = !railWayLWEvening.getRailwaySourceList().isEmpty();
            boolean night = !railWayLWNight.getRailwaySourceList().isEmpty();
            for (int iSource = 0; iSource < 6; ++iSource) {
                heightSource = 0.0;
                switch (iSource) {
                    case 0: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("ROLLING")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("ROLLING")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("ROLLING")).getlW();
                        }
                        if (day) {
                            heightSource = 4.0;
                        }
                        directivityId = 1;
                        break;
                    }
                    case 1: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("TRACTIONA")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("TRACTIONA")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("TRACTIONA")).getlW();
                        }
                        heightSource = 0.5;
                        directivityId = 2;
                        break;
                    }
                    case 2: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("TRACTIONB")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("TRACTIONB")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("TRACTIONB")).getlW();
                        }
                        heightSource = 4.0;
                        directivityId = 3;
                        break;
                    }
                    case 3: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("AERODYNAMICA")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("AERODYNAMICA")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("AERODYNAMICA")).getlW();
                        }
                        heightSource = 0.5;
                        directivityId = 4;
                        break;
                    }
                    case 4: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("AERODYNAMICB")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("AERODYNAMICB")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("AERODYNAMICB")).getlW();
                        }
                        heightSource = 4.0;
                        directivityId = 5;
                        break;
                    }
                    case 5: {
                        if (day) {
                            LWDay = ((LineSource)railWayLWDay.getRailwaySourceList().get("BRIDGE")).getlW();
                        }
                        if (evening) {
                            LWEvening = ((LineSource)railWayLWEvening.getRailwaySourceList().get("BRIDGE")).getlW();
                        }
                        if (night) {
                            LWNight = ((LineSource)railWayLWNight.getRailwaySourceList().get("BRIDGE")).getlW();
                        }
                        heightSource = 0.5;
                        directivityId = 6;
                    }
                }
                PreparedStatement ps = connection.prepareStatement(insertIntoQuery.toString());
                for (Geometry geometry : geometries) {
                    Geometry sourceGeometry = ST_UpdateZ.updateZ((Geometry)ST_Force3D.force3D((Geometry)geometry), (double)heightSource).copy();
                    int cursor = 1;
                    ps.setInt(cursor++, pk);
                    ps.setObject(cursor++, sourceGeometry);
                    ps.setInt(cursor++, directivityId);
                    ps.setDouble(cursor++, railWayLWGeom.getGs());
                    for (double v : LWDay) {
                        ps.setDouble(cursor++, v);
                    }
                    for (double v : LWEvening) {
                        ps.setDouble(cursor++, v);
                    }
                    for (double v : LWNight) {
                        ps.setDouble(cursor++, v);
                    }
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        connection.createStatement().execute("ALTER TABLE " + outputTable + " ADD PK INT AUTO_INCREMENT PRIMARY KEY;");
    }

    public static enum STANDARD_PERIOD {
        DAY,
        EVENING,
        NIGHT;

    }
}

