/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.input;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.h2gis.utilities.SpatialResultSet;
import org.locationtech.jts.geom.Geometry;
import org.noise_planet.noisemodelling.jdbc.EmissionTableGenerator;
import org.noise_planet.noisemodelling.jdbc.input.SceneDatabaseInputSettings;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;

public class SceneWithEmission
extends SceneWithAttenuation {
    Map<String, Integer> sourceEmissionFieldsCache = new HashMap<String, Integer>();
    public Map<Long, ArrayList<PeriodEmission>> wjSources = new HashMap<Long, ArrayList<PeriodEmission>>();
    public SceneDatabaseInputSettings sceneDatabaseInputSettings = new SceneDatabaseInputSettings();

    public SceneWithEmission(ProfileBuilder profileBuilder, SceneDatabaseInputSettings sceneDatabaseInputSettings) {
        super(profileBuilder);
        this.sceneDatabaseInputSettings = sceneDatabaseInputSettings;
    }

    public SceneWithEmission(ProfileBuilder profileBuilder) {
        super(profileBuilder);
    }

    public SceneWithEmission() {
    }

    public void processTrafficFlowDEN(Long pk, SpatialResultSet rs) throws SQLException {
        double[][] lw = EmissionTableGenerator.computeLw(rs, this.sceneDatabaseInputSettings.coefficientVersion, this.sourceFieldNames);
        for (EmissionTableGenerator.STANDARD_PERIOD period : EmissionTableGenerator.STANDARD_PERIOD.values()) {
            this.addSourceEmission(pk, EmissionTableGenerator.STANDARD_PERIOD_VALUE[period.ordinal()], lw[period.ordinal()]);
        }
    }

    public void processTrafficFlow(Long pk, ResultSet rs) throws SQLException {
        int sourceIndex;
        String period = rs.getString("PERIOD");
        double defaultSlope = 0.0;
        if (!this.sourceEmissionFieldsCache.containsKey("SLOPE") && (sourceIndex = this.sourcesPk.indexOf(pk)) >= 0) {
            defaultSlope = EmissionTableGenerator.getSlope((Geometry)this.sourceGeometries.get(sourceIndex));
        }
        double[] lw = AcousticIndicatorsFunctions.dBToW((double[])EmissionTableGenerator.getEmissionFromTrafficTable(rs, "", defaultSlope, this.sceneDatabaseInputSettings.coefficientVersion, this.sourceEmissionFieldsCache));
        this.addSourceEmission(pk, period, lw);
    }

    public void processEmission(Long pk, ResultSet rs) throws SQLException {
        double[] lw = new double[this.profileBuilder.frequencyArray.size()];
        List frequencyArray = this.profileBuilder.frequencyArray;
        int frequencyArraySize = frequencyArray.size();
        for (int i = 0; i < frequencyArraySize; ++i) {
            Integer frequency = (Integer)frequencyArray.get(i);
            lw[i] = AcousticIndicatorsFunctions.dBToW((double)rs.getDouble(this.sceneDatabaseInputSettings.frequencyFieldPrepend + frequency));
        }
        String period = rs.getString("PERIOD");
        this.addSourceEmission(pk, period, lw);
    }

    public void addSource(Long pk, Geometry geom, SpatialResultSet rs) throws SQLException {
        super.addSource(pk, geom, rs);
        switch (Objects.requireNonNull(this.sceneDatabaseInputSettings.inputMode)) {
            case INPUT_MODE_TRAFFIC_FLOW_DEN: {
                this.processTrafficFlowDEN(pk, rs);
                break;
            }
            case INPUT_MODE_LW_DEN: {
                this.processEmissionDEN(pk, rs);
            }
        }
    }

    private void processEmissionDEN(Long pk, SpatialResultSet rs) throws SQLException {
        List frequencyArray = this.profileBuilder.frequencyArray;
        for (EmissionTableGenerator.STANDARD_PERIOD period : EmissionTableGenerator.STANDARD_PERIOD.values()) {
            double[] lw = new double[this.profileBuilder.frequencyArray.size()];
            boolean missingField = false;
            String periodFieldName = EmissionTableGenerator.STANDARD_PERIOD_VALUE[period.ordinal()];
            int frequencyArraySize = frequencyArray.size();
            for (int i = 0; i < frequencyArraySize; ++i) {
                Integer frequency = (Integer)frequencyArray.get(i);
                String tableFieldName = this.sceneDatabaseInputSettings.frequencyFieldPrepend + periodFieldName + frequency;
                if (!this.sourceFieldNames.containsKey(tableFieldName)) {
                    missingField = true;
                    break;
                }
                lw[i] = AcousticIndicatorsFunctions.dBToW((double)rs.getDouble(tableFieldName));
            }
            if (missingField) continue;
            this.addSourceEmission(pk, periodFieldName, lw);
        }
    }

    public void addSourceEmission(Long pk, ResultSet rs) throws SQLException {
        switch (this.sceneDatabaseInputSettings.inputMode) {
            case INPUT_MODE_TRAFFIC_FLOW: {
                this.processTrafficFlow(pk, rs);
                break;
            }
            case INPUT_MODE_LW: {
                this.processEmission(pk, rs);
            }
        }
    }

    public void addSourceEmission(Long sourcePrimaryKey, String period, double[] wj) {
        ArrayList<Object> sourceEmissions;
        if (this.wjSources.containsKey(sourcePrimaryKey)) {
            sourceEmissions = this.wjSources.get(sourcePrimaryKey);
        } else {
            sourceEmissions = new ArrayList();
            this.wjSources.put(sourcePrimaryKey, sourceEmissions);
        }
        sourceEmissions.add(new PeriodEmission(period, wj));
        if (!period.isEmpty()) {
            this.periodSet.add(period);
        }
    }

    public void clearSources() {
        super.clearSources();
        this.sourceEmissionFieldsCache.clear();
        this.wjSources.clear();
    }

    public static class PeriodEmission {
        public final String period;
        public final double[] emission;

        public PeriodEmission(String period, double[] emission) {
            this.period = period;
            this.emission = emission;
        }
    }
}

