/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2gis.api.ProgressVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.jdbc.EmissionTableGenerator;
import org.noise_planet.noisemodelling.jdbc.NoiseMapDatabaseParameters;
import org.noise_planet.noisemodelling.jdbc.input.SceneDatabaseInputSettings;
import org.noise_planet.noisemodelling.jdbc.input.SceneWithEmission;
import org.noise_planet.noisemodelling.jdbc.output.AttenuationOutputMultiThread;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitor;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.noise_planet.noisemodelling.propagation.ReceiverNoiseLevel;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;
import org.noise_planet.noisemodelling.propagation.cnossos.AttenuationCnossos;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPathBuilder;

public class AttenuationOutputSingleThread
implements CutPlaneVisitor {
    private static final int UNKNOWN_SOURCE_ID = -1;
    AttenuationOutputMultiThread multiThread;
    NoiseMapDatabaseParameters dbSettings;
    public List<CnossosPath> cnossosPaths = new ArrayList<CnossosPath>();
    Map<Integer, TimePeriodParameters> receiverAttenuationList = new HashMap<Integer, TimePeriodParameters>();
    Map<String, Double> wjAtReceiver = new HashMap<String, Double>();
    Map<String, HashMap<Coordinate, Double>> maximumWjExpectedSplAtReceiver = new HashMap<String, HashMap<Coordinate, Double>>();
    public AtomicInteger cutProfileCount = new AtomicInteger(0);
    ProgressVisitor progressVisitor;

    public AttenuationOutputSingleThread(AttenuationOutputMultiThread multiThreadParent, ProgressVisitor progressVisitor) {
        this.multiThread = multiThreadParent;
        this.dbSettings = multiThreadParent.noiseMapDatabaseParameters;
        this.progressVisitor = progressVisitor;
    }

    private static double[] computeFastAttenuation(PathFinder.SourcePointInfo sourceInfo, PathFinder.ReceiverPointInfo receiverInfo, AttenuationParameters cnossosParameters) {
        double distance = Math.max(1.0, sourceInfo.position.distance3D(receiverInfo.position));
        double attenuationDivGeom = AttenuationCnossos.getADiv((double)distance) - 3.0;
        return AcousticIndicatorsFunctions.multiplicationArray((double[])AcousticIndicatorsFunctions.sumArray((double[])AttenuationCnossos.aAtm((double[])cnossosParameters.getAlpha_atmo(), (double)distance), (double)attenuationDivGeom), (double)-1.0);
    }

    private double[] processAndStoreAttenuation(AttenuationParameters data, CnossosPath proPathParameters, String period) {
        double[] attenuation = AttenuationCnossos.computeCnossosAttenuation((AttenuationParameters)data, (CnossosPath)proPathParameters, (SceneWithAttenuation)this.multiThread.sceneWithEmission, (boolean)this.multiThread.noiseMapDatabaseParameters.exportAttenuationMatrix);
        if (this.multiThread.noiseMapDatabaseParameters.exportRaysMethod == NoiseMapDatabaseParameters.ExportRaysMethods.TO_RAYS_TABLE && this.multiThread.noiseMapDatabaseParameters.exportAttenuationMatrix) {
            CnossosPath cnossosPath = new CnossosPath(proPathParameters);
            cnossosPath.setTimePeriod(period);
            this.cnossosPaths.add(cnossosPath);
        }
        return attenuation;
    }

    private void processNoiseLevel(ReceiverNoiseLevel noiseLevel) {
        int keyToUpdate = -1;
        if (!this.dbSettings.isMergeSources()) {
            keyToUpdate = noiseLevel.source.sourceIndex;
        }
        TimePeriodParameters periodParameters = new TimePeriodParameters(this.dbSettings.isMergeSources() ? new PathFinder.SourcePointInfo() : noiseLevel.source, noiseLevel.period, noiseLevel.levels);
        this.receiverAttenuationList.merge(keyToUpdate, periodParameters, TimePeriodParameters::update);
    }

    public CutPlaneVisitor.PathSearchStrategy onNewCutPlane(CutProfile cutProfile) {
        this.cutProfileCount.addAndGet(1);
        CutPlaneVisitor.PathSearchStrategy strategy = CutPlaneVisitor.PathSearchStrategy.CONTINUE;
        SceneWithEmission scene = this.multiThread.sceneWithEmission;
        CnossosPath cnossosPath = CnossosPathBuilder.computeCnossosPathFromCutProfile((CutProfile)cutProfile, (boolean)scene.isBodyBarrier(), (List)scene.profileBuilder.exactFrequencyArray, (double)scene.defaultGroundAttenuation);
        if (cnossosPath != null) {
            String period;
            ArrayList<SceneWithEmission.PeriodEmission> emissions;
            long sourcePk;
            this.multiThread.cnossosPathCount.addAndGet(1L);
            CutPointSource source = cutProfile.getSource();
            CutPointReceiver receiver = cutProfile.getReceiver();
            long l = sourcePk = source.sourcePk == -1L ? (long)source.id : source.sourcePk;
            if (this.multiThread.noiseMapDatabaseParameters.exportRaysMethod == NoiseMapDatabaseParameters.ExportRaysMethods.TO_RAYS_TABLE && !this.multiThread.noiseMapDatabaseParameters.exportAttenuationMatrix) {
                this.cnossosPaths.add(cnossosPath);
            }
            if (scene.wjSources.isEmpty()) {
                if (!scene.cnossosParametersPerPeriod.isEmpty()) {
                    for (Map.Entry cnossosParametersEntry : scene.cnossosParametersPerPeriod.entrySet()) {
                        double[] attenuation = AcousticIndicatorsFunctions.dBToW((double[])this.processAndStoreAttenuation((AttenuationParameters)cnossosParametersEntry.getValue(), cnossosPath, (String)cnossosParametersEntry.getKey()));
                        ReceiverNoiseLevel receiverNoiseLevel = new ReceiverNoiseLevel(new PathFinder.SourcePointInfo(source), new PathFinder.ReceiverPointInfo(receiver), (String)cnossosParametersEntry.getKey(), attenuation);
                        this.processNoiseLevel(receiverNoiseLevel);
                    }
                } else {
                    double[] attenuation = AcousticIndicatorsFunctions.dBToW((double[])this.processAndStoreAttenuation(scene.defaultCnossosParameters, cnossosPath, ""));
                    ReceiverNoiseLevel receiverNoiseLevel = new ReceiverNoiseLevel(new PathFinder.SourcePointInfo(source), new PathFinder.ReceiverPointInfo(receiver), "", attenuation);
                    this.processNoiseLevel(receiverNoiseLevel);
                }
            } else {
                double[] defaultAttenuation = new double[]{};
                if (scene.wjSources.containsKey(sourcePk)) {
                    emissions = scene.wjSources.get(sourcePk);
                    for (SceneWithEmission.PeriodEmission periodEmission : emissions) {
                        period = periodEmission.period;
                        double[] attenuation = new double[]{};
                        if (scene.cnossosParametersPerPeriod.containsKey(period)) {
                            attenuation = AcousticIndicatorsFunctions.dBToW((double[])this.processAndStoreAttenuation((AttenuationParameters)scene.cnossosParametersPerPeriod.get(period), cnossosPath, period));
                        } else {
                            if (defaultAttenuation.length == 0) {
                                defaultAttenuation = AcousticIndicatorsFunctions.dBToW((double[])this.processAndStoreAttenuation(scene.defaultCnossosParameters, cnossosPath, ""));
                            }
                            attenuation = defaultAttenuation;
                        }
                        double[] levels = AcousticIndicatorsFunctions.multiplicationArray((double[])attenuation, (double[])periodEmission.emission);
                        ReceiverNoiseLevel receiverNoiseLevel = new ReceiverNoiseLevel(new PathFinder.SourcePointInfo(source), new PathFinder.ReceiverPointInfo(receiver), period, levels);
                        this.processNoiseLevel(receiverNoiseLevel);
                        if (!(this.dbSettings.maximumError > 0.0)) continue;
                        double powerSum = AcousticIndicatorsFunctions.sumArray((double[])levels);
                        this.wjAtReceiver.merge(period, powerSum, Double::sum);
                    }
                }
            }
            if (this.dbSettings.maximumError > 0.0 && scene.wjSources.containsKey(sourcePk)) {
                boolean keepRunning = false;
                emissions = scene.wjSources.get(sourcePk);
                for (SceneWithEmission.PeriodEmission periodEmission : emissions) {
                    period = periodEmission.period;
                    if (!this.maximumWjExpectedSplAtReceiver.containsKey(period)) continue;
                    this.maximumWjExpectedSplAtReceiver.get(period).remove(source.coordinate);
                    if (!this.maximumWjExpectedSplAtReceiver.get(period).isEmpty()) continue;
                    this.maximumWjExpectedSplAtReceiver.remove(period);
                }
                for (Map.Entry entry : this.wjAtReceiver.entrySet()) {
                    double nonProcessedPower;
                    double maximumExpectedLevelInDb;
                    double dBDiff;
                    period = (String)entry.getKey();
                    double levelAtReceiver = (Double)entry.getValue();
                    if (!this.maximumWjExpectedSplAtReceiver.containsKey(period) || !((dBDiff = (maximumExpectedLevelInDb = AcousticIndicatorsFunctions.wToDb((double)(levelAtReceiver + (nonProcessedPower = this.maximumWjExpectedSplAtReceiver.get(period).values().stream().reduce(Double::sum).orElse(0.0).doubleValue())))) - AcousticIndicatorsFunctions.wToDb((double)levelAtReceiver)) > this.dbSettings.maximumError)) continue;
                    keepRunning = true;
                    break;
                }
                if (!keepRunning) {
                    strategy = CutPlaneVisitor.PathSearchStrategy.PROCESS_SOURCE_BUT_SKIP_RECEIVER;
                }
            }
        }
        return strategy;
    }

    public void startReceiver(PathFinder.ReceiverPointInfo receiver, Collection<PathFinder.SourcePointInfo> sourceList, AtomicInteger cutProfileCount) {
        this.cutProfileCount = cutProfileCount;
        if (this.dbSettings.getMaximumError() > 0.0 && !this.multiThread.sceneWithEmission.wjSources.isEmpty()) {
            this.wjAtReceiver = new HashMap<String, Double>(this.multiThread.sceneWithEmission.periodSet.size());
            for (String period : this.multiThread.sceneWithEmission.periodSet) {
                this.wjAtReceiver.put(period, 0.0);
            }
            this.maximumWjExpectedSplAtReceiver.clear();
            SceneWithEmission scene = this.multiThread.sceneWithEmission;
            for (PathFinder.SourcePointInfo sourcePointInfo : sourceList) {
                double[] attenuation = AcousticIndicatorsFunctions.dBToW((double[])AttenuationOutputSingleThread.computeFastAttenuation(sourcePointInfo, receiver, scene.defaultCnossosParameters));
                if (!scene.wjSources.containsKey(sourcePointInfo.sourcePk)) continue;
                ArrayList<SceneWithEmission.PeriodEmission> emissions = scene.wjSources.get(sourcePointInfo.sourcePk);
                for (SceneWithEmission.PeriodEmission periodEmission : emissions) {
                    HashMap<Object, Object> sourceLevel;
                    double[] wjAtReceiver = AcousticIndicatorsFunctions.multiplicationArray((double[])attenuation, (double[])periodEmission.emission);
                    double sumPower = AcousticIndicatorsFunctions.sumArray((double[])wjAtReceiver);
                    if (!this.maximumWjExpectedSplAtReceiver.containsKey(periodEmission.period)) {
                        sourceLevel = new HashMap();
                        this.maximumWjExpectedSplAtReceiver.put(periodEmission.period, sourceLevel);
                    } else {
                        sourceLevel = this.maximumWjExpectedSplAtReceiver.get(periodEmission.period);
                    }
                    sourceLevel.merge(sourcePointInfo.getCoord(), sumPower, Double::sum);
                }
            }
        }
    }

    public void pushInStack(ConcurrentLinkedDeque<ReceiverNoiseLevel> stack, ReceiverNoiseLevel data) {
        while (this.multiThread.resultsCache.queueSize.get() > (long)this.dbSettings.outputMaximumQueue) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                this.multiThread.aborted.set(true);
                break;
            }
            if (!this.multiThread.aborted.get()) continue;
            this.progressVisitor.cancel();
            return;
        }
        stack.add(data);
        this.multiThread.resultsCache.queueSize.incrementAndGet();
    }

    public void pushInStack(ConcurrentLinkedDeque<CnossosPath> stack, Collection<CnossosPath> data) {
        while (this.multiThread.resultsCache.queueSize.get() > (long)this.dbSettings.outputMaximumQueue) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                this.multiThread.aborted.set(true);
                break;
            }
            if (!this.multiThread.aborted.get()) continue;
            this.progressVisitor.cancel();
            return;
        }
        if (this.dbSettings.getMaximumRaysOutputCount() == 0 || this.multiThread.resultsCache.totalRaysInserted.get() < (long)this.dbSettings.getMaximumRaysOutputCount()) {
            long newTotalRays = this.multiThread.resultsCache.totalRaysInserted.addAndGet(data.size());
            if (this.dbSettings.getMaximumRaysOutputCount() > 0 && newTotalRays > (long)this.dbSettings.getMaximumRaysOutputCount()) {
                int newListSize = data.size() - (int)(newTotalRays - (long)this.dbSettings.getMaximumRaysOutputCount());
                if (newListSize > 0) {
                    ArrayList<CnossosPath> subList = new ArrayList<CnossosPath>(newListSize);
                    for (CnossosPath pathParameters : data) {
                        subList.add(pathParameters);
                        if (subList.size() < newListSize) continue;
                        break;
                    }
                    data = subList;
                } else {
                    data = Collections.emptyList();
                }
            }
            stack.addAll(data);
            this.multiThread.resultsCache.queueSize.addAndGet(data.size());
        }
    }

    private static double[] getSpectrum(List<double[]> spectrum, int index) {
        if (index >= 0 && index < spectrum.size()) {
            return spectrum.get(index);
        }
        return new double[0];
    }

    public void finalizeReceiver(PathFinder.ReceiverPointInfo receiver) {
        if (!this.cnossosPaths.isEmpty() && this.dbSettings.getExportRaysMethod() == NoiseMapDatabaseParameters.ExportRaysMethods.TO_RAYS_TABLE) {
            this.pushInStack(this.multiThread.resultsCache.cnossosPaths, this.cnossosPaths);
        }
        boolean computeLden = this.isComputeLden();
        HashSet<String> collectedPeriod = new HashSet<String>();
        for (Map.Entry<Integer, TimePeriodParameters> periodParametersEntry : this.receiverAttenuationList.entrySet()) {
            TimePeriodParameters periodParameters = periodParametersEntry.getValue();
            for (Map.Entry<String, double[]> levelsAtPeriod : periodParameters.levelsPerPeriod.entrySet()) {
                this.pushInStack(this.multiThread.resultsCache.receiverLevels, new ReceiverNoiseLevel(periodParameters.source, receiver, levelsAtPeriod.getKey(), AcousticIndicatorsFunctions.wToDb((double[])levelsAtPeriod.getValue())));
                if (!this.dbSettings.isMergeSources()) continue;
                collectedPeriod.add(levelsAtPeriod.getKey());
            }
            if (!computeLden) continue;
            double[] lden = new double[]{};
            for (EmissionTableGenerator.STANDARD_PERIOD period : EmissionTableGenerator.STANDARD_PERIOD.values()) {
                double[] levels = periodParameters.levelsPerPeriod.getOrDefault(EmissionTableGenerator.STANDARD_PERIOD_VALUE[period.ordinal()], new double[0]);
                lden = AcousticIndicatorsFunctions.sumArray((double[])lden, (double[])AcousticIndicatorsFunctions.multiplicationArray((double[])levels, (double)EmissionTableGenerator.RATIOS[period.ordinal()]));
            }
            this.pushInStack(this.multiThread.resultsCache.receiverLevels, new ReceiverNoiseLevel(periodParameters.source, receiver, "DEN", AcousticIndicatorsFunctions.wToDb((double[])lden)));
            if (!this.dbSettings.isMergeSources()) continue;
            collectedPeriod.add("DEN");
        }
        if (this.dbSettings.isMergeSources()) {
            HashSet<String> difference = new HashSet<String>(this.multiThread.sceneWithEmission.periodSet);
            if (computeLden) {
                difference.add("DEN");
            }
            difference.removeAll(collectedPeriod);
            double[] levels = new double[this.multiThread.sceneWithEmission.profileBuilder.frequencyArray.size()];
            Arrays.fill(levels, this.dbSettings.noSourceNoiseLevel);
            for (String period : difference) {
                this.pushInStack(this.multiThread.resultsCache.receiverLevels, new ReceiverNoiseLevel(new PathFinder.SourcePointInfo(), receiver, period, levels));
            }
        }
        this.receiverAttenuationList.clear();
        this.maximumWjExpectedSplAtReceiver.clear();
        this.wjAtReceiver.clear();
        this.cnossosPaths.clear();
    }

    private boolean isComputeLden() {
        SceneDatabaseInputSettings.INPUT_MODE inputMode = this.multiThread.sceneWithEmission.sceneDatabaseInputSettings.getInputMode();
        return inputMode.equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_TRAFFIC_FLOW_DEN) || inputMode.equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_LW_DEN);
    }

    public static class TimePeriodParameters {
        public PathFinder.SourcePointInfo source = null;
        public Map<String, double[]> levelsPerPeriod = new HashMap<String, double[]>();

        public TimePeriodParameters(PathFinder.SourcePointInfo source) {
            this.source = source;
        }

        public TimePeriodParameters(PathFinder.SourcePointInfo source, String period, double[] attenuation) {
            this.source = source;
            this.levelsPerPeriod.put(period, attenuation);
        }

        public TimePeriodParameters() {
        }

        public TimePeriodParameters update(TimePeriodParameters other) {
            for (Map.Entry<String, double[]> entry : other.levelsPerPeriod.entrySet()) {
                this.levelsPerPeriod.merge(entry.getKey(), entry.getValue(), AcousticIndicatorsFunctions::sumArray);
            }
            return this;
        }
    }
}

