/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.output;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.h2gis.api.ProgressVisitor;
import org.noise_planet.noisemodelling.jdbc.NoiseMapByReceiverMaker;
import org.noise_planet.noisemodelling.jdbc.NoiseMapDatabaseParameters;
import org.noise_planet.noisemodelling.jdbc.input.SceneWithEmission;
import org.noise_planet.noisemodelling.jdbc.output.AttenuationOutputMultiThread;
import org.noise_planet.noisemodelling.jdbc.output.NoiseMapWriter;
import org.noise_planet.noisemodelling.jdbc.output.ResultsCache;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitorFactory;
import org.noise_planet.noisemodelling.pathfinder.ThreadPool;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.JVMMemoryMetric;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ProfilerThread;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ProgressMetric;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ReceiverStatsMetric;

public class DefaultCutPlaneProcessing
implements NoiseMapByReceiverMaker.IComputeRaysOutFactory {
    ResultsCache resultsCache = new ResultsCache();
    final NoiseMapDatabaseParameters noiseMapDatabaseParameters;
    NoiseMapWriter noiseMapWriter;
    ProfilerThread profilerThread;
    Connection connection;
    AtomicBoolean exitWhenDone;
    AtomicBoolean aborted;
    NoiseMapByReceiverMaker noiseMapByReceiverMaker;
    ThreadPool postProcessingThreadPool = new ThreadPool();
    Future<Boolean> noiseMapWriterFuture;

    public DefaultCutPlaneProcessing(NoiseMapDatabaseParameters noiseMapDatabaseParameters, AtomicBoolean exitWhenDone, AtomicBoolean aborted) {
        this.noiseMapDatabaseParameters = noiseMapDatabaseParameters;
        this.exitWhenDone = exitWhenDone;
        this.aborted = aborted;
    }

    @Override
    public CutPlaneVisitorFactory create(SceneWithEmission scene) {
        return new AttenuationOutputMultiThread(scene, this.resultsCache, this.noiseMapDatabaseParameters, this.exitWhenDone, this.aborted);
    }

    @Override
    public void initialize(Connection connection, NoiseMapByReceiverMaker noiseMapByReceiverMaker) throws SQLException {
        this.connection = connection;
        this.noiseMapByReceiverMaker = noiseMapByReceiverMaker;
        if (this.noiseMapDatabaseParameters.CSVProfilerOutputPath != null) {
            this.profilerThread = new ProfilerThread(this.noiseMapDatabaseParameters.CSVProfilerOutputPath);
            this.profilerThread.addMetric((ProfilerThread.Metric)this.resultsCache);
            this.profilerThread.addMetric((ProfilerThread.Metric)new JVMMemoryMetric());
            this.profilerThread.addMetric((ProfilerThread.Metric)new ReceiverStatsMetric());
            this.profilerThread.setWriteInterval(this.noiseMapDatabaseParameters.CSVProfilerWriteInterval);
            this.profilerThread.setFlushInterval(this.noiseMapDatabaseParameters.CSVProfilerWriteInterval);
        }
    }

    @Override
    public void start(ProgressVisitor progressLogger) throws SQLException {
        this.noiseMapWriter = new NoiseMapWriter(this.connection, this.noiseMapByReceiverMaker, this.resultsCache, this.exitWhenDone, this.aborted);
        this.exitWhenDone.set(false);
        if (this.profilerThread != null) {
            this.profilerThread.addMetric((ProfilerThread.Metric)new ProgressMetric(progressLogger));
            this.postProcessingThreadPool.submit((Runnable)this.profilerThread);
        }
        try {
            this.noiseMapWriter.init();
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        this.noiseMapWriterFuture = this.postProcessingThreadPool.submitBlocking((Callable)this.noiseMapWriter);
    }

    @Override
    public void stop() throws SQLException {
        this.exitWhenDone.set(true);
        try {
            this.noiseMapWriterFuture.get();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

