/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.output;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.noise_planet.noisemodelling.jdbc.NoiseMapByReceiverMaker;
import org.noise_planet.noisemodelling.jdbc.NoiseMapDatabaseParameters;
import org.noise_planet.noisemodelling.jdbc.input.DefaultTableLoader;
import org.noise_planet.noisemodelling.jdbc.input.SceneDatabaseInputSettings;
import org.noise_planet.noisemodelling.jdbc.output.ResultsCache;
import org.noise_planet.noisemodelling.jdbc.utils.StringPreparedStatements;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.CoordinateMixin;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.LineSegmentMixin;
import org.noise_planet.noisemodelling.propagation.ReceiverNoiseLevel;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoiseMapWriter
implements Callable<Boolean> {
    static final int LOG_END_WRITING_DELAY = 15000;
    static final int BATCH_MAX_SIZE = 500;
    static final int WRITER_CACHE = 65536;
    AtomicBoolean exitWhenDone;
    AtomicBoolean aborted;
    Logger LOGGER = LoggerFactory.getLogger(NoiseMapWriter.class);
    File sqlFilePath;
    private Connection connection;
    NoiseMapByReceiverMaker noiseMapByReceiverMaker;
    NoiseMapDatabaseParameters databaseParameters;
    ResultsCache resultsCache;
    Writer writer;
    ObjectWriter jsonWriter;
    int srid;
    public List<Integer> frequencyArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((int[])ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE));
    public double[] aWeightingArray = Arrays.stream(AcousticIndicatorsFunctions.asOctaveBands((Double[])ProfileBuilder.DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE)).mapToDouble(value -> value).toArray();

    public NoiseMapWriter(Connection connection, NoiseMapByReceiverMaker noiseMapByReceiverMaker, ResultsCache ResultsCache2, AtomicBoolean exitWhenDone, AtomicBoolean aborted) {
        this.connection = connection;
        this.noiseMapByReceiverMaker = noiseMapByReceiverMaker;
        this.databaseParameters = noiseMapByReceiverMaker.getNoiseMapDatabaseParameters();
        this.resultsCache = ResultsCache2;
        this.srid = noiseMapByReceiverMaker.getGeometryFactory().getSRID();
        if (noiseMapByReceiverMaker.getPropagationProcessDataFactory() instanceof DefaultTableLoader) {
            this.aWeightingArray = ((DefaultTableLoader)noiseMapByReceiverMaker.getPropagationProcessDataFactory()).aWeightingArray.stream().mapToDouble(value -> value).toArray();
            this.frequencyArray = ((DefaultTableLoader)noiseMapByReceiverMaker.getPropagationProcessDataFactory()).frequencyArray;
        }
        this.exitWhenDone = exitWhenDone;
        this.aborted = aborted;
        if (this.databaseParameters.exportCnossosPathWithAttenuation) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(Coordinate.class, CoordinateMixin.class);
            mapper.addMixIn(LineSegment.class, LineSegmentMixin.class);
            this.jsonWriter = mapper.writer();
        }
    }

    public String propagationPathAsJSON(CnossosPath path) throws JsonProcessingException {
        return this.jsonWriter.writeValueAsString((Object)path);
    }

    public static CnossosPath jsonToPropagationPath(String json) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return (CnossosPath)mapper.readValue(json, CnossosPath.class);
    }

    void processRaysStack(ConcurrentLinkedDeque<CnossosPath> stack) throws SQLException {
        boolean exportPeriod = !this.noiseMapByReceiverMaker.getSceneInputSettings().getInputMode().equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION);
        StringBuilder query = new StringBuilder("INSERT INTO " + this.databaseParameters.raysTable + "(the_geom , IDRECEIVER , IDSOURCE");
        if (this.databaseParameters.exportCnossosPathWithAttenuation) {
            query.append(", PATH");
        }
        if (this.databaseParameters.exportAttenuationMatrix) {
            query.append(", LEQ");
        }
        if (exportPeriod) {
            query.append(", PERIOD");
        }
        query.append(") VALUES (?, ?, ?");
        if (this.databaseParameters.exportCnossosPathWithAttenuation) {
            query.append(", ?");
        }
        if (this.databaseParameters.exportAttenuationMatrix) {
            query.append(", ?");
        }
        if (exportPeriod) {
            query.append(", ?");
        }
        query.append(");");
        PreparedStatement ps = this.sqlFilePath == null ? this.connection.prepareStatement(query.toString()) : new StringPreparedStatements(this.writer, query.toString());
        int batchSize = 0;
        while (!stack.isEmpty()) {
            CnossosPath row = stack.pop();
            this.resultsCache.queueSize.decrementAndGet();
            int parameterIndex = 1;
            LineString lineString = row.asGeom();
            lineString.setSRID(this.srid);
            ps.setObject(parameterIndex++, lineString);
            ps.setLong(parameterIndex++, row.getCutProfile().getReceiver().receiverPk);
            ps.setLong(parameterIndex++, row.getCutProfile().getSource().sourcePk);
            if (this.databaseParameters.exportCnossosPathWithAttenuation) {
                String json = "";
                try {
                    json = this.propagationPathAsJSON(row);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ps.setString(parameterIndex++, json);
            }
            if (this.databaseParameters.exportAttenuationMatrix) {
                double globalValue = AcousticIndicatorsFunctions.sumDbArray((double[])row.aGlobal);
                ps.setDouble(parameterIndex++, globalValue);
            }
            if (exportPeriod) {
                ps.setString(parameterIndex++, row.getTimePeriod());
            }
            ps.addBatch();
            if (++batchSize < 500) continue;
            ps.executeBatch();
            ps.clearBatch();
            batchSize = 0;
        }
        if (batchSize > 0) {
            ps.executeBatch();
        }
    }

    void processStack(String tableName, ConcurrentLinkedDeque<ReceiverNoiseLevel> stack) throws SQLException {
        long lastInfoLog = 0L;
        if (stack.isEmpty()) {
            return;
        }
        boolean exportPeriod = !this.noiseMapByReceiverMaker.getSceneInputSettings().getInputMode().equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION);
        StringBuilder query = new StringBuilder("INSERT INTO ");
        query.append(tableName);
        query.append(" VALUES (? ");
        if (!this.databaseParameters.mergeSources) {
            query.append(", ?");
        }
        if (exportPeriod) {
            query.append(", ?");
        }
        if (this.databaseParameters.exportReceiverPosition) {
            query.append(", ?");
        }
        if (!this.databaseParameters.computeLAEQOnly) {
            query.append(", ?".repeat(this.aWeightingArray.length));
            query.append(", ?, ?);");
        } else {
            query.append(", ?);");
        }
        PreparedStatement ps = this.sqlFilePath == null ? this.connection.prepareStatement(query.toString()) : new StringPreparedStatements(this.writer, query.toString());
        int batchSize = 0;
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), this.srid);
        while (!stack.isEmpty() && !this.aborted.get()) {
            double value;
            ReceiverNoiseLevel row = stack.pop();
            this.resultsCache.queueSize.decrementAndGet();
            int parameterIndex = 1;
            ps.setLong(parameterIndex++, row.receiver.receiverPk);
            if (!this.databaseParameters.mergeSources) {
                ps.setLong(parameterIndex++, row.source.sourcePk);
            }
            if (exportPeriod) {
                ps.setString(parameterIndex++, row.period);
            }
            if (this.databaseParameters.exportReceiverPosition) {
                ps.setObject(parameterIndex++, row.receiver.position != null ? factory.createPoint(row.receiver.position) : factory.createPoint());
            }
            if (!this.databaseParameters.computeLAEQOnly) {
                for (int idfreq = 0; idfreq < this.aWeightingArray.length; ++idfreq) {
                    double value2 = row.levels[idfreq];
                    if (!Double.isFinite(value2)) {
                        row.levels[idfreq] = value2 = -99.0;
                    }
                    ps.setDouble(parameterIndex++, value2);
                }
            }
            if (!Double.isFinite(value = AcousticIndicatorsFunctions.wToDb((double)AcousticIndicatorsFunctions.sumArray((double[])AcousticIndicatorsFunctions.dBToW((double[])AcousticIndicatorsFunctions.sumArray((double[])row.levels, (double[])this.aWeightingArray)))))) {
                value = -99.0;
            }
            ps.setDouble(parameterIndex++, value);
            if (!this.databaseParameters.computeLAEQOnly) {
                ps.setDouble(parameterIndex++, AcousticIndicatorsFunctions.wToDb((double)AcousticIndicatorsFunctions.sumArray((double[])AcousticIndicatorsFunctions.dBToW((double[])row.levels))));
            }
            ps.addBatch();
            if (++batchSize < 500) continue;
            ps.executeBatch();
            ps.clearBatch();
            batchSize = 0;
            long now = System.currentTimeMillis();
            if (!this.exitWhenDone.get() || now - lastInfoLog <= 15000L) continue;
            this.LOGGER.info("Calculation end, writing last {} records..", (Object)stack.size());
            lastInfoLog = now;
        }
        if (batchSize > 0) {
            ps.executeBatch();
        }
    }

    private String forgeCreateTable(String tableName) {
        boolean exportPeriod = !this.noiseMapByReceiverMaker.getSceneInputSettings().getInputMode().equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION);
        StringBuilder sb = new StringBuilder("create table ");
        sb.append(tableName);
        if (!this.databaseParameters.mergeSources) {
            sb.append(" (IDRECEIVER bigint NOT NULL");
            sb.append(", IDSOURCE bigint NOT NULL");
        } else {
            sb.append(" (IDRECEIVER bigint NOT NULL");
        }
        if (exportPeriod) {
            sb.append(", PERIOD VARCHAR NOT NULL");
        }
        if (this.databaseParameters.exportReceiverPosition) {
            sb.append(", THE_GEOM GEOMETRY(POINTZ,");
            sb.append(this.srid);
            sb.append(")");
        }
        if (this.databaseParameters.computeLAEQOnly) {
            sb.append(", LAEQ REAL");
            sb.append(");");
        } else {
            for (int idfreq = 0; idfreq < this.aWeightingArray.length; ++idfreq) {
                sb.append(", " + this.noiseMapByReceiverMaker.getFrequencyFieldPrepend());
                sb.append(this.frequencyArray.get(idfreq));
                sb.append(" REAL");
            }
            sb.append(", LAEQ REAL, LEQ REAL");
            sb.append(");");
        }
        return sb.toString();
    }

    private String forgePkTable(String tableName) {
        boolean exportPeriod;
        boolean bl = exportPeriod = !this.noiseMapByReceiverMaker.getSceneInputSettings().getInputMode().equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION);
        if (this.databaseParameters.mergeSources) {
            if (!exportPeriod) {
                return "ALTER TABLE " + tableName + " ADD PRIMARY KEY(IDRECEIVER);";
            }
            return "ALTER TABLE " + tableName + " ADD PRIMARY KEY(IDRECEIVER, PERIOD);";
        }
        if (!exportPeriod) {
            return "CREATE INDEX ON " + tableName + " (IDRECEIVER, IDSOURCE);";
        }
        return "CREATE INDEX ON " + tableName + " (IDRECEIVER, IDSOURCE, PERIOD);";
    }

    private void processQuery(String query) throws SQLException, IOException {
        if (this.sqlFilePath == null) {
            try (Statement sql = this.connection.createStatement();){
                sql.execute(query);
            }
        } else {
            this.writer.write(query + "\n");
        }
    }

    public void init() throws SQLException, IOException {
        if (this.databaseParameters.getExportRaysMethod() == NoiseMapDatabaseParameters.ExportRaysMethods.TO_RAYS_TABLE) {
            boolean exportPeriod;
            boolean bl = exportPeriod = !this.noiseMapByReceiverMaker.getSceneInputSettings().getInputMode().equals((Object)SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION);
            if (this.databaseParameters.dropResultsTable.booleanValue()) {
                String q = String.format("DROP TABLE IF EXISTS %s;", this.databaseParameters.raysTable);
                this.processQuery(q);
            }
            StringBuilder sb = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.databaseParameters.raysTable + "(pk bigint auto_increment, the_geom geometry(LINESTRING Z,");
            sb.append(this.srid);
            sb.append("), IDRECEIVER bigint NOT NULL, IDSOURCE bigint NOT NULL");
            if (this.databaseParameters.exportCnossosPathWithAttenuation) {
                sb.append(", PATH VARCHAR");
            }
            if (this.databaseParameters.exportAttenuationMatrix) {
                sb.append(", LEQ DOUBLE");
            }
            if (exportPeriod) {
                sb.append(", PERIOD VARCHAR");
            }
            sb.append(");");
            this.processQuery(sb.toString());
        }
        if (this.databaseParameters.dropResultsTable.booleanValue()) {
            String q = String.format("DROP TABLE IF EXISTS %s;", this.databaseParameters.receiversLevelTable);
            this.processQuery(q);
        }
        String q = this.forgeCreateTable(this.databaseParameters.receiversLevelTable);
        this.processQuery(q);
    }

    void mainLoop() throws SQLException, IOException {
        while (!this.aborted.get()) {
            try {
                if (!this.resultsCache.receiverLevels.isEmpty()) {
                    this.processStack(this.databaseParameters.receiversLevelTable, this.resultsCache.receiverLevels);
                    continue;
                }
                if (!this.resultsCache.cnossosPaths.isEmpty()) {
                    this.processRaysStack(this.resultsCache.cnossosPaths);
                    continue;
                }
                if (this.exitWhenDone.get()) break;
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    void createKeys() throws SQLException, IOException {
        this.LOGGER.info("Write done, apply primary keys");
        this.processQuery(this.forgePkTable(this.databaseParameters.receiversLevelTable));
        this.LOGGER.info("Primary keys applied");
    }

    OutputStreamWriter getStream() throws IOException {
        if (this.databaseParameters.sqlOutputFileCompression.booleanValue()) {
            return new OutputStreamWriter(new GZIPOutputStream((OutputStream)new FileOutputStream(this.sqlFilePath), 65536));
        }
        return new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.sqlFilePath), 65536));
    }

    @Override
    public Boolean call() throws Exception {
        if (this.sqlFilePath == null) {
            try {
                this.mainLoop();
                this.createKeys();
            }
            catch (Exception e) {
                this.aborted.set(true);
                throw e;
            }
        }
        try (OutputStreamWriter bw = this.getStream();){
            this.writer = bw;
            this.mainLoop();
            this.createKeys();
        }
        catch (Exception e) {
            this.aborted.set(true);
            throw e;
        }
        return true;
    }
}

