/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.railway;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.noise_planet.noisemodelling.emission.railway.RailWayParameters;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailWayCnossosParameters;
import org.noise_planet.noisemodelling.jdbc.utils.MakeParallelLines;

public class RailWayLWGeom {
    RailWayCnossosParameters railWayLW;
    RailWayCnossosParameters railWayLWDay;
    RailWayCnossosParameters railWayLWEvening;
    RailWayCnossosParameters railWayLWNight;
    List<LineString> geometry;
    int pk = -1;
    int nbTrack;
    String idSection;
    double distance = 2.0;
    double gs = 1.0;

    public RailWayLWGeom() {
    }

    public RailWayLWGeom(RailWayLWGeom other) {
        this.railWayLW = other.railWayLW;
        this.railWayLWDay = other.railWayLWDay;
        this.railWayLWEvening = other.railWayLWEvening;
        this.railWayLWNight = other.railWayLWNight;
        this.geometry = other.geometry;
        this.pk = other.pk;
        this.nbTrack = other.nbTrack;
        this.idSection = other.idSection;
        this.distance = other.distance;
        this.gs = other.gs;
    }

    public double getGs() {
        return this.gs;
    }

    public void setGs(double gs) {
        this.gs = gs;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public RailWayParameters getRailWayLW() {
        return this.railWayLW;
    }

    public void setRailWayLW(RailWayCnossosParameters railWayLW) {
        this.railWayLW = railWayLW;
    }

    public RailWayParameters getRailWayLWDay() {
        return this.railWayLWDay;
    }

    public void setRailWayLWDay(RailWayCnossosParameters railWayLWDay) {
        this.railWayLWDay = railWayLWDay;
    }

    public RailWayParameters getRailWayLWEvening() {
        return this.railWayLWEvening;
    }

    public void setRailWayLWEvening(RailWayCnossosParameters railWayLWEvening) {
        this.railWayLWEvening = railWayLWEvening;
    }

    public RailWayParameters getRailWayLWNight() {
        return this.railWayLWNight;
    }

    public void setRailWayLWNight(RailWayCnossosParameters railWayLWNight) {
        this.railWayLWNight = railWayLWNight;
    }

    public int getNbTrack() {
        return this.nbTrack;
    }

    public String getIdSection() {
        return this.idSection;
    }

    public void setIdSection(String idSection) {
        this.idSection = idSection;
    }

    public void setNbTrack(int nbTrack) {
        this.nbTrack = nbTrack;
    }

    public List<LineString> getGeometry() {
        return this.geometry;
    }

    public int getPK() {
        return this.pk;
    }

    public int setPK(int pk) {
        this.pk = pk;
        return this.pk;
    }

    public void setGeometry(List<LineString> geometry) {
        this.geometry = geometry;
    }

    public List<LineString> getRailWayLWGeometry() {
        ArrayList<LineString> geometries = new ArrayList<LineString>();
        boolean even = false;
        if (this.nbTrack % 2 == 0) {
            even = true;
        }
        if (this.nbTrack == 1) {
            geometries.addAll(this.getGeometry());
            return geometries;
        }
        if (even) {
            for (int j = 0; j < this.nbTrack / 2; ++j) {
                for (LineString subGeom : this.getGeometry()) {
                    geometries.add(MakeParallelLines.MakeParallelLine(subGeom, this.distance / 2.0 + this.distance * (double)j));
                    geometries.add(MakeParallelLines.MakeParallelLine(subGeom, -(this.distance / 2.0 + this.distance * (double)j)));
                }
            }
        } else {
            for (int j = 1; j <= (this.nbTrack - 1) / 2; ++j) {
                for (LineString subGeom : this.getGeometry()) {
                    geometries.add(MakeParallelLines.MakeParallelLine(subGeom, this.distance * (double)j));
                    geometries.add(MakeParallelLines.MakeParallelLine(subGeom, -(this.distance * (double)j)));
                }
            }
            LineMerger centerLine = new LineMerger();
            centerLine.add(this.getGeometry());
            geometries.addAll(centerLine.getMergedLineStrings());
        }
        return geometries;
    }
}

