/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.railway;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailWayCnossosParameters;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailwayCnossos;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailwayTrackCnossosParameters;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailwayVehicleCnossosParameters;
import org.noise_planet.noisemodelling.jdbc.railway.RailWayLWGeom;

public class RailWayLWIterator
implements Iterator<RailWayLWGeom> {
    private RailwayCnossos railway = new RailwayCnossos();
    private Connection connection;
    private RailWayLWGeom railWayLWComplete = null;
    private RailWayLWGeom railWayLWIncomplete = new RailWayLWGeom();
    private String tableTrackGeometry;
    private String tableTrainTraffic;
    private SpatialResultSet spatialResultSet;
    public Map<String, Integer> sourceFields = null;

    public RailWayLWIterator(Connection connection, String tableTrackGeometry, String tableTrainTraffic) {
        this.railway.setVehicleDataFile("RailwayVehiclesCnossos.json");
        this.railway.setTrainSetDataFile("RailwayTrainsets.json");
        this.railway.setRailwayDataFile("RailwayCnossosSNCF_2021.json");
        this.connection = connection;
        this.tableTrackGeometry = tableTrackGeometry;
        this.tableTrainTraffic = tableTrainTraffic;
        this.railWayLWComplete = this.fetchNext(this.railWayLWIncomplete);
    }

    public RailWayLWIterator(Connection connection, String tableTrackGeometry, String tableTrainTraffic, String vehicleDataFile, String trainSetDataFile, String railwayDataFile) {
        this.railway.setVehicleDataFile(vehicleDataFile);
        this.railway.setTrainSetDataFile(trainSetDataFile);
        this.railway.setRailwayDataFile(railwayDataFile);
        this.connection = connection;
        this.tableTrackGeometry = tableTrackGeometry;
        this.tableTrainTraffic = tableTrainTraffic;
        this.railWayLWComplete = this.fetchNext(this.railWayLWIncomplete);
    }

    @Override
    public boolean hasNext() {
        return this.railWayLWComplete != null;
    }

    private List<LineString> splitGeometry(Geometry geometry) {
        ArrayList<LineString> inputLineStrings = new ArrayList<LineString>();
        for (int id = 0; id < geometry.getNumGeometries(); ++id) {
            Geometry subGeom = geometry.getGeometryN(id);
            if (!(subGeom instanceof LineString)) continue;
            inputLineStrings.add((LineString)subGeom);
        }
        return inputLineStrings;
    }

    public static boolean hasColumn(SpatialResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        for (int x = 1; x <= columns; ++x) {
            if (!columnName.equals(rsmd.getColumnName(x))) continue;
            return true;
        }
        return false;
    }

    @Override
    public RailWayLWGeom next() {
        RailWayLWGeom current = this.railWayLWComplete;
        this.railWayLWComplete = this.fetchNext(this.railWayLWIncomplete);
        return current;
    }

    public RailWayLWGeom current() {
        return this.railWayLWComplete;
    }

    private RailWayLWGeom fetchNext(RailWayLWGeom incompleteRecord) {
        RailWayLWGeom completeRecord = null;
        try {
            boolean hasNext = false;
            if (this.spatialResultSet == null) {
                Tuple trackKey = JDBCUtilities.getIntegerPrimaryKeyNameAndIndex((Connection)this.connection, (TableLocation)TableLocation.parse((String)this.tableTrackGeometry, (DBTypes)DBUtils.getDBType((Connection)this.connection)));
                this.spatialResultSet = this.connection.createStatement().executeQuery("SELECT r1." + (String)trackKey.first() + " trackid, r1.*, r2.* FROM " + this.tableTrackGeometry + " r1, " + this.tableTrainTraffic + " r2 WHERE r1.IDSECTION=R2.IDSECTION ORDER BY R1." + (String)trackKey.first()).unwrap(SpatialResultSet.class);
                if (!this.spatialResultSet.next()) {
                    return null;
                }
                hasNext = true;
                if (this.sourceFields == null) {
                    this.sourceFields = new HashMap<String, Integer>();
                    int fieldId = 1;
                    for (String fieldName : JDBCUtilities.getColumnNames((ResultSetMetaData)this.spatialResultSet.getMetaData())) {
                        this.sourceFields.put(fieldName.toUpperCase(), fieldId++);
                    }
                }
                if (this.sourceFields.containsKey("TRACKSPC")) {
                    incompleteRecord.distance = this.spatialResultSet.getDouble("TRACKSPC");
                }
                incompleteRecord.setRailWayLW(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY"));
                incompleteRecord.setRailWayLWDay(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY"));
                incompleteRecord.setRailWayLWEvening(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "EVENING"));
                incompleteRecord.setRailWayLWNight(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "NIGHT"));
                incompleteRecord.nbTrack = this.spatialResultSet.getInt("NTRACK");
                incompleteRecord.idSection = this.spatialResultSet.getString("IDSECTION");
                if (RailWayLWIterator.hasColumn(this.spatialResultSet, "GS")) {
                    incompleteRecord.gs = this.spatialResultSet.getDouble("GS");
                }
                incompleteRecord.pk = this.spatialResultSet.getInt("trackid");
                incompleteRecord.geometry = this.splitGeometry(this.spatialResultSet.getGeometry());
            }
            if (incompleteRecord.pk == -1) {
                return null;
            }
            while (this.spatialResultSet.next()) {
                hasNext = true;
                if (incompleteRecord.pk == this.spatialResultSet.getInt("trackid")) {
                    incompleteRecord.setRailWayLW(RailWayCnossosParameters.sumRailwaySource((RailWayCnossosParameters)incompleteRecord.railWayLW, (RailWayCnossosParameters)this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY")));
                    incompleteRecord.setRailWayLWDay(RailWayCnossosParameters.sumRailwaySource((RailWayCnossosParameters)incompleteRecord.railWayLWDay, (RailWayCnossosParameters)this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY")));
                    incompleteRecord.setRailWayLWEvening(RailWayCnossosParameters.sumRailwaySource((RailWayCnossosParameters)incompleteRecord.railWayLWEvening, (RailWayCnossosParameters)this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "EVENING")));
                    incompleteRecord.setRailWayLWNight(RailWayCnossosParameters.sumRailwaySource((RailWayCnossosParameters)incompleteRecord.railWayLWNight, (RailWayCnossosParameters)this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "NIGHT")));
                    continue;
                }
                completeRecord = new RailWayLWGeom(incompleteRecord);
                incompleteRecord.geometry = this.splitGeometry(this.spatialResultSet.getGeometry());
                if (this.sourceFields.containsKey("TRACKSPC")) {
                    incompleteRecord.distance = this.spatialResultSet.getDouble("TRACKSPC");
                }
                incompleteRecord.setRailWayLW(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY"));
                incompleteRecord.setRailWayLWDay(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "DAY"));
                incompleteRecord.setRailWayLWEvening(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "EVENING"));
                incompleteRecord.setRailWayLWNight(this.getRailwayEmissionFromResultSet((ResultSet)this.spatialResultSet, "NIGHT"));
                incompleteRecord.nbTrack = this.spatialResultSet.getInt("NTRACK");
                incompleteRecord.idSection = this.spatialResultSet.getString("IDSECTION");
                if (RailWayLWIterator.hasColumn(this.spatialResultSet, "GS")) {
                    incompleteRecord.gs = this.spatialResultSet.getDouble("GS");
                }
                incompleteRecord.pk = this.spatialResultSet.getInt("trackid");
                incompleteRecord.geometry = this.splitGeometry(this.spatialResultSet.getGeometry());
                break;
            }
            if (!hasNext) {
                incompleteRecord.pk = -1;
            } else if (completeRecord == null) {
                completeRecord = new RailWayLWGeom(incompleteRecord);
            }
            return completeRecord;
        }
        catch (IOException | SQLException throwables) {
            throw new NoSuchElementException(throwables.getMessage());
        }
    }

    public RailWayCnossosParameters getRailwayEmissionFromResultSet(ResultSet rs, String period) throws SQLException, IOException {
        String train = "FRET";
        double vehicleSpeed = 160.0;
        double vehiclePerHour = 1.0;
        int rollingCondition = 0;
        double idlingTime = 0.0;
        int trackTransfer = 4;
        int impactNoise = 0;
        int bridgeTransfert = 0;
        int curvature = 0;
        int railRoughness = 1;
        int nbTrack = 2;
        double vMaxInfra = 160.0;
        double commercialSpeed = 160.0;
        boolean isTunnel = false;
        String idSection = "";
        if (this.sourceFields.containsKey("TRAINSPD")) {
            vehicleSpeed = rs.getDouble("TRAINSPD");
        }
        if (this.sourceFields.containsKey("T" + period)) {
            vehiclePerHour = rs.getDouble("T" + period);
        }
        if (this.sourceFields.containsKey("ROLLINGCONDITION")) {
            rollingCondition = rs.getInt("ROLLINGCONDITION");
        }
        if (this.sourceFields.containsKey("IDLINGTIME")) {
            idlingTime = rs.getDouble("IDLINGTIME");
        }
        if (this.sourceFields.containsKey("TRANSFER")) {
            trackTransfer = rs.getInt("TRANSFER");
        }
        if (this.sourceFields.containsKey("ROUGHNESS")) {
            railRoughness = rs.getInt("ROUGHNESS");
        }
        if (this.sourceFields.containsKey("IMPACT")) {
            impactNoise = rs.getInt("IMPACT");
        }
        if (this.sourceFields.containsKey("BRIDGE")) {
            bridgeTransfert = rs.getInt("BRIDGE");
        }
        if (this.sourceFields.containsKey("CURVATURE")) {
            curvature = rs.getInt("CURVATURE");
        }
        if (this.sourceFields.containsKey("TRACKSPD")) {
            vMaxInfra = rs.getDouble("TRACKSPD");
        }
        if (this.sourceFields.containsKey("COMSPD")) {
            commercialSpeed = rs.getDouble("COMSPD");
        }
        if (this.sourceFields.containsKey("TRAINTYPE")) {
            train = rs.getString("TRAINTYPE");
        }
        if (this.sourceFields.containsKey("TYPETRAIN")) {
            train = rs.getString("TYPETRAIN");
        }
        if (this.sourceFields.containsKey("ISTUNNEL")) {
            isTunnel = rs.getBoolean("ISTUNNEL");
        }
        if (this.sourceFields.containsKey("IDTUNNEL")) {
            String idTunnel = rs.getString("IDTUNNEL");
            boolean bl = isTunnel = idTunnel != null && !idTunnel.trim().isEmpty();
        }
        if (this.sourceFields.containsKey("NTRACK")) {
            nbTrack = rs.getInt("NTRACK");
        }
        RailWayCnossosParameters lWRailWay = new RailWayCnossosParameters();
        RailwayTrackCnossosParameters trackParameters = new RailwayTrackCnossosParameters(vMaxInfra, trackTransfer, railRoughness, impactNoise, bridgeTransfert, curvature, commercialSpeed, isTunnel, nbTrack);
        Map vehicles = this.railway.getVehicleFromTrainset(train);
        if (vehicles != null) {
            int i = 0;
            for (Map.Entry entry : vehicles.entrySet()) {
                String typeTrain = (String)entry.getKey();
                double vehiclePerHouri = vehiclePerHour * (double)((Integer)entry.getValue()).intValue();
                if (vehiclePerHouri > 0.0) {
                    RailwayVehicleCnossosParameters vehicleParameters = new RailwayVehicleCnossosParameters(typeTrain, vehicleSpeed, vehiclePerHouri / (double)nbTrack, rollingCondition, idlingTime);
                    lWRailWay = i == 0 ? this.railway.evaluate(vehicleParameters, trackParameters) : RailWayCnossosParameters.sumRailwaySource((RailWayCnossosParameters)lWRailWay, (RailWayCnossosParameters)this.railway.evaluate(vehicleParameters, trackParameters));
                }
                ++i;
            }
        } else if (this.railway.isInVehicleList(train) && vehiclePerHour > 0.0) {
            RailwayVehicleCnossosParameters vehicleParameters = new RailwayVehicleCnossosParameters(train, vehicleSpeed, vehiclePerHour / (double)nbTrack, rollingCondition, idlingTime);
            lWRailWay = this.railway.evaluate(vehicleParameters, trackParameters);
        }
        return lWRailWay;
    }
}

