/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.h2gis.functions.spatial.convert.ST_Force2D;
import org.h2gis.functions.spatial.convert.ST_Force3D;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.h2gis.utilities.jts_utils.Contouring;
import org.h2gis.utilities.jts_utils.TriMarkers;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.noise_planet.noisemodelling.emission.utils.Utils;
import org.noise_planet.noisemodelling.jdbc.utils.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoSurface {
    Logger log = LoggerFactory.getLogger(IsoSurface.class);
    static final int BATCH_MAX_SIZE = 500;
    String pointTable = "RECEIVERS_LEVEL";
    String triangleTable = "TRIANGLES";
    String outputTable = "CONTOURING_NOISE_MAP";
    String pointTableField = "LAEQ";
    List<Double> isoLevels;
    List<String> isoLabels;
    boolean smooth = true;
    boolean mergeTriangles = true;
    double smoothCoefficient = 1.0;
    double deltaPoints = 0.5;
    double epsilon = 0.05;
    int srid;
    public static final List<Double> NF31_133_ISO = Collections.unmodifiableList(Arrays.asList(35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 200.0));
    private int exportDimension = 2;

    public IsoSurface(List<Double> isoLevels, int srid) {
        this.isoLevels = new ArrayList<Double>(isoLevels.size());
        this.isoLabels = new ArrayList<String>(isoLevels.size());
        this.srid = srid;
        DecimalFormat format = new DecimalFormat("#.##");
        for (int idiso = 0; idiso < isoLevels.size(); ++idiso) {
            double lvl = isoLevels.get(idiso);
            this.isoLevels.add(Utils.dbaToW((double)lvl));
            if (idiso == 0) {
                this.isoLabels.add(String.format(Locale.ROOT, "-%s", format.format(lvl)));
                continue;
            }
            if (idiso < isoLevels.size() - 1) {
                this.isoLabels.add(String.format(Locale.ROOT, "%s-%s", format.format(isoLevels.get(idiso - 1)), format.format(lvl)));
                continue;
            }
            this.isoLabels.add(String.format(Locale.ROOT, "%s+", format.format(isoLevels.get(idiso - 1))));
        }
    }

    public void setIsoLabels(List<String> isoLabels) {
        this.isoLabels = isoLabels;
    }

    public void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    public double getSmoothCoefficient() {
        return this.smoothCoefficient;
    }

    public boolean isMergeTriangles() {
        return this.mergeTriangles;
    }

    public void setMergeTriangles(boolean mergeTriangles) {
        this.mergeTriangles = mergeTriangles;
    }

    public void setSmoothCoefficient(double smoothCoefficient) {
        this.smoothCoefficient = smoothCoefficient;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public String getPointTableField() {
        return this.pointTableField;
    }

    static List<Coordinate> curve4(Coordinate anchor1, Coordinate control1, Coordinate control2, Coordinate anchor2, int numSteps) {
        double subdiv_step = 1.0 / (double)(numSteps + 1);
        double subdiv_step2 = subdiv_step * subdiv_step;
        double subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        double pre1 = 3.0 * subdiv_step;
        double pre2 = 3.0 * subdiv_step2;
        double pre4 = 6.0 * subdiv_step2;
        double pre5 = 6.0 * subdiv_step3;
        double tmp1x = anchor1.x - control1.x * 2.0 + control2.x;
        double tmp1y = anchor1.y - control1.y * 2.0 + control2.y;
        double tmp2x = (control1.x - control2.x) * 3.0 - anchor1.x + anchor2.x;
        double tmp2y = (control1.y - control2.y) * 3.0 - anchor1.y + anchor2.y;
        double fx = anchor1.x;
        double fy = anchor1.y;
        double dfx = (control1.x - anchor1.x) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        double dfy = (control1.y - anchor1.y) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        double ddfx = tmp1x * pre4 + tmp2x * pre5;
        double ddfy = tmp1y * pre4 + tmp2y * pre5;
        double dddfx = tmp2x * pre5;
        double dddfy = tmp2y * pre5;
        int step = numSteps;
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>(numSteps);
        while (step-- > 0) {
            dfx += ddfx;
            ddfx += dddfx;
            ddfy += dddfy;
            ret.add(new Coordinate(fx += dfx, fy += (dfy += ddfy)));
        }
        ret.add(new Coordinate(anchor2.x, anchor2.y));
        return ret;
    }

    static Coordinate[] generateBezierCurves(Coordinate[] coordinates, Quadtree segmentTree, double pointsDelta) {
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        pts.add(new Coordinate(coordinates[0].x, coordinates[0].y));
        for (int i = 0; i < coordinates.length - 1; ++i) {
            int i2 = i + 1;
            Coordinate p1 = new Coordinate(coordinates[i].x, coordinates[i].y);
            Coordinate p2 = new Coordinate(coordinates[i2].x, coordinates[i2].y);
            Segment segment = new Segment(p1, p2);
            List segments = segmentTree.query(segment.getEnvelope());
            boolean insert = false;
            for (Segment s : segments) {
                if (!segment.equals(s)) continue;
                if (s.getControlPoints().size() <= 2) break;
                insert = true;
                int numSteps = Math.max(4, (int)Math.ceil(p1.distance(p2) / pointsDelta));
                Coordinate ctrl1 = s.getControlPoints().get(0);
                Coordinate ctrl2 = s.getControlPoints().get(1);
                if (!s.p0.equals((Object)p1)) {
                    ctrl1 = s.getControlPoints().get(1);
                    ctrl2 = s.getControlPoints().get(0);
                }
                pts.addAll(IsoSurface.curve4(p1, ctrl1, ctrl2, p2, numSteps));
                break;
            }
            if (insert) continue;
            pts.add(p2);
        }
        return pts.toArray(new Coordinate[0]);
    }

    static void computeBezierControlPoints(Coordinate[] coordinates, double smoothValue, Quadtree segmentTree) {
        int i;
        Coordinate[] midPoint = new Coordinate[coordinates.length];
        double[] len = new double[coordinates.length];
        for (i = 0; i < coordinates.length; ++i) {
            int i2 = i + 1 >= coordinates.length ? i + 1 - (coordinates.length - 1) : i + 1;
            midPoint[i] = new Coordinate((coordinates[i].x + coordinates[i2].x) / 2.0, (coordinates[i].y + coordinates[i2].y) / 2.0);
            len[i] = coordinates[i].distance(coordinates[i2]);
        }
        for (i = 0; i < coordinates.length - 1; ++i) {
            int i0 = i - 1 < 0 ? coordinates.length - 2 : i - 1;
            int i2 = i + 1;
            Coordinate p1 = coordinates[i];
            Coordinate p2 = coordinates[i2];
            double x1 = p1.x;
            double y1 = p1.y;
            double x2 = p2.x;
            double y2 = p2.y;
            double xc1 = midPoint[i0].x;
            double yc1 = midPoint[i0].y;
            double xc2 = midPoint[i].x;
            double yc2 = midPoint[i].y;
            double xc3 = midPoint[i2].x;
            double yc3 = midPoint[i2].y;
            double len1 = len[i0];
            double len2 = len[i];
            double len3 = len[i2];
            double k1 = len1 / (len1 + len2);
            double k2 = len2 / (len2 + len3);
            double xm1 = xc1 + (xc2 - xc1) * k1;
            double ym1 = yc1 + (yc2 - yc1) * k1;
            double xm2 = xc2 + (xc3 - xc2) * k2;
            double ym2 = yc2 + (yc3 - yc2) * k2;
            double ctrl1_x = xm1 + (xc2 - xm1) * smoothValue + x1 - xm1;
            double ctrl1_y = ym1 + (yc2 - ym1) * smoothValue + y1 - ym1;
            double ctrl2_x = xm2 + (xc2 - xm2) * smoothValue + x2 - xm2;
            double ctrl2_y = ym2 + (yc2 - ym2) * smoothValue + y2 - ym2;
            Segment segment = new Segment(p1, p2);
            List segments = segmentTree.query(segment.getEnvelope());
            boolean exists = false;
            for (Segment s : segments) {
                if (!segment.equals(s)) continue;
                exists = true;
                s.addControlPoints(new Coordinate(ctrl1_x, ctrl1_y), new Coordinate(ctrl2_x, ctrl2_y));
                break;
            }
            if (exists) continue;
            segment.addControlPoints(new Coordinate(ctrl1_x, ctrl1_y), new Coordinate(ctrl2_x, ctrl2_y));
            segmentTree.insert(segment.getEnvelope(), (Object)segment);
        }
    }

    public void setPointTableField(String pointTableField) {
        this.pointTableField = pointTableField;
    }

    public String getPointTable() {
        return this.pointTable;
    }

    public void setPointTable(String pointTable) {
        this.pointTable = pointTable;
    }

    public String getTriangleTable() {
        return this.triangleTable;
    }

    public void setTriangleTable(String triangleTable) {
        this.triangleTable = triangleTable;
    }

    public String getOutputTable() {
        return this.outputTable;
    }

    public void setOutputTable(String outputTable) {
        this.outputTable = outputTable;
    }

    void explode(Geometry geom, List<Polygon> polygons) {
        if (geom instanceof Polygon) {
            polygons.add((Polygon)geom);
        } else if (geom instanceof GeometryCollection) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                this.explode(geom.getGeometryN(i), polygons);
            }
        }
    }

    void processCell(Connection connection, int cellId, Map<Short, ArrayList<Geometry>> polys, String period, boolean aggregateByPeriod) throws SQLException {
        Polygon polygon;
        Iterator<Object> iterator;
        Object polygons;
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), this.srid);
        if (this.smooth) {
            Quadtree segmentTree = new Quadtree();
            for (Map.Entry<Short, ArrayList<Geometry>> entry : polys.entrySet()) {
                CascadedPolygonUnion union = new CascadedPolygonUnion((Collection)entry.getValue());
                Geometry mergeTriangles = union.union();
                polygons = new ArrayList<Polygon>();
                this.explode(mergeTriangles, (List<Polygon>)polygons);
                iterator = ((ArrayList)polygons).iterator();
                while (iterator.hasNext()) {
                    polygon = iterator.next();
                    Coordinate[] extRing = polygon.getExteriorRing().getCoordinates();
                    IsoSurface.computeBezierControlPoints(extRing, this.smoothCoefficient, segmentTree);
                    LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
                    for (int idHole = 0; idHole < holes.length; ++idHole) {
                        IsoSurface.computeBezierControlPoints(polygon.getInteriorRingN(idHole).getCoordinates(), this.smoothCoefficient, segmentTree);
                    }
                }
                entry.getValue().clear();
                entry.getValue().add(mergeTriangles);
            }
            for (Map.Entry<Short, ArrayList<Geometry>> entry : polys.entrySet()) {
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                if (entry.getValue().size() != 1) continue;
                ArrayList<Polygon> polygons2 = new ArrayList<Polygon>();
                this.explode(entry.getValue().get(0), polygons2);
                for (Polygon polygon2 : polygons2) {
                    if (polygon2.isEmpty()) continue;
                    Coordinate[] extRing = IsoSurface.generateBezierCurves(polygon2.getExteriorRing().getCoordinates(), segmentTree, this.deltaPoints);
                    LinearRing[] holes = new LinearRing[polygon2.getNumInteriorRing()];
                    for (int idHole = 0; idHole < holes.length; ++idHole) {
                        Coordinate[] hole = IsoSurface.generateBezierCurves(polygon2.getInteriorRingN(idHole).getCoordinates(), segmentTree, this.deltaPoints);
                        holes[idHole] = factory.createLinearRing(hole);
                    }
                    polygon2 = factory.createPolygon(factory.createLinearRing(extRing), holes);
                    TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier((Geometry)polygon2);
                    simplifier.setDistanceTolerance(this.epsilon);
                    Geometry res = simplifier.getResultGeometry();
                    if (res instanceof Polygon) {
                        polygon2 = (Polygon)res;
                    }
                    newPolygons.add(polygon2);
                }
                entry.getValue().clear();
                entry.getValue().addAll(newPolygons);
            }
        }
        int batchSize = 0;
        StringBuilder insertQuery = new StringBuilder().append("INSERT INTO ").append(TableLocation.parse((String)this.outputTable)).append("(cell_id");
        if (aggregateByPeriod) {
            insertQuery.append(", PERIOD");
        }
        insertQuery.append(", the_geom, ISOLVL, ISOLABEL) VALUES (?");
        if (aggregateByPeriod) {
            insertQuery.append(", ?");
        }
        insertQuery.append(", ?, ?, ?);");
        try (PreparedStatement ps = connection.prepareStatement(insertQuery.toString());){
            for (Map.Entry<Short, ArrayList<Geometry>> entry : polys.entrySet()) {
                polygons = new ArrayList();
                if (!this.smooth && this.mergeTriangles) {
                    try {
                        CascadedPolygonUnion union = new CascadedPolygonUnion((Collection)entry.getValue());
                        Geometry mergeTriangles = union.union();
                        this.explode(mergeTriangles, (List<Polygon>)polygons);
                    }
                    catch (TopologyException t) {
                        this.log.warn(t.getLocalizedMessage(), (Throwable)t);
                        this.explode((Geometry)factory.createGeometryCollection(entry.getValue().toArray(new Geometry[0])), (List<Polygon>)polygons);
                    }
                } else {
                    this.explode((Geometry)factory.createGeometryCollection(entry.getValue().toArray(new Geometry[0])), (List<Polygon>)polygons);
                }
                iterator = ((ArrayList)polygons).iterator();
                while (iterator.hasNext()) {
                    polygon = (Polygon)iterator.next();
                    int geomDim = 0;
                    boolean mixedDimension = false;
                    for (Coordinate coordinate : polygon.getExteriorRing().getCoordinates()) {
                        if (Double.isNaN(coordinate.getZ())) {
                            if (geomDim == 0) {
                                geomDim = 2;
                                continue;
                            }
                            if (geomDim != 3) continue;
                            mixedDimension = true;
                            continue;
                        }
                        if (geomDim == 0) {
                            geomDim = 3;
                            continue;
                        }
                        if (geomDim != 2) continue;
                        mixedDimension = true;
                    }
                    if (geomDim != this.exportDimension || mixedDimension) {
                        if (this.exportDimension == 3) {
                            polygon = ST_Force3D.convert((Polygon)polygon, (double)0.0);
                            polygon.setSRID(this.srid);
                        } else {
                            polygon = (Polygon)ST_Force2D.force2D((Geometry)polygon);
                            polygon.setSRID(this.srid);
                        }
                    }
                    int parameterIndex = 1;
                    ps.setInt(parameterIndex++, cellId);
                    if (aggregateByPeriod) {
                        ps.setString(parameterIndex++, period);
                    }
                    ps.setObject(parameterIndex++, polygon);
                    ps.setInt(parameterIndex++, entry.getKey().shortValue());
                    ps.setString(parameterIndex++, this.isoLabels.get(entry.getKey().shortValue()));
                    ps.addBatch();
                    if (++batchSize < 500) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                    batchSize = 0;
                }
            }
            if (batchSize > 0) {
                ps.executeBatch();
            }
        }
    }

    public void createTable(Connection connection) throws SQLException {
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        List fields = JDBCUtilities.getColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)this.pointTable, (DBTypes)dbType));
        int pk = JDBCUtilities.getIntegerPrimaryKey((Connection)connection.unwrap(Connection.class), (TableLocation)TableLocation.parse((String)this.pointTable, (DBTypes)dbType));
        if (pk == 0) {
            throw new SQLException(this.pointTable + " does not contain a primary key");
        }
        String pkField = (String)fields.get(pk - 1);
        this.createTable(connection, pkField);
    }

    public void createTable(Connection connection, String pkField) throws SQLException {
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        String periodField = TableLocation.capsIdentifier((String)"PERIOD", (DBTypes)dbType);
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), this.srid);
        boolean aggregateByPeriod = JDBCUtilities.hasField((Connection)connection, (String)this.pointTable, (String)periodField);
        int lastCellId = -1;
        try (Statement st = connection.createStatement();){
            String geometryType = "GEOMETRY(POLYGONZ," + this.srid + ")";
            this.exportDimension = 3;
            if (this.smooth && this.smoothCoefficient > 0.0) {
                geometryType = "GEOMETRY(POLYGON," + this.srid + ")";
                this.exportDimension = 2;
            }
            st.execute("DROP TABLE IF EXISTS " + TableLocation.parse((String)this.outputTable, (DBTypes)dbType));
            StringBuilder createTableQuery = new StringBuilder();
            createTableQuery.append("CREATE TABLE ").append(TableLocation.parse((String)this.outputTable, (DBTypes)dbType)).append("(PK SERIAL");
            if (aggregateByPeriod) {
                createTableQuery.append(", PERIOD VARCHAR");
            }
            createTableQuery.append(", CELL_ID INTEGER, THE_GEOM ").append(geometryType).append(", ISOLVL INTEGER, ISOLABEL VARCHAR);");
            st.execute(createTableQuery.toString());
            StringBuilder selectQuery = new StringBuilder();
            selectQuery.append("SELECT CELL_ID, ST_X(p1.the_geom) xa,ST_Y(p1.the_geom) ya, ST_Z(p1.the_geom) za,").append("ST_X(p2.the_geom) xb,ST_Y(p2.the_geom) yb, ST_Z(p2.the_geom) zb,").append("ST_X(p3.the_geom) xc,ST_Y(p3.the_geom) yc, ST_Z(p3.the_geom) zc,").append(" p1.").append(this.pointTableField).append(" lvla, p2.").append(this.pointTableField).append(" lvlb, p3.").append(this.pointTableField).append(" lvlc FROM ").append(this.triangleTable).append(" t, ").append(this.pointTable).append(" p1,").append(this.pointTable).append(" p2,").append(this.pointTable).append(" p3 WHERE t.PK_1 = p1.").append(pkField).append(" and t.PK_2 = p2.").append(pkField).append(" AND t.PK_3 = p3.").append(pkField);
            if (aggregateByPeriod) {
                selectQuery.append(" AND p1.PERIOD = ? AND p1.PERIOD=p2.period AND p1.period = p3.period");
            }
            selectQuery.append(" order by cell_id;");
            PreparedStatement statement = connection.prepareStatement(selectQuery.toString());
            ArrayList<String> periods = new ArrayList<String>();
            if (!aggregateByPeriod) {
                periods.add("");
            } else {
                periods.addAll(JDBCUtilities.getUniqueFieldValues((Connection)connection, (String)this.pointTable, (String)periodField));
            }
            for (String period : periods) {
                if (aggregateByPeriod) {
                    statement.setString(1, period);
                }
                HashMap<Short, ArrayList<Geometry>> polyMap = new HashMap<Short, ArrayList<Geometry>>();
                try (ResultSet rs = statement.executeQuery();){
                    int xa = 0;
                    int xb = 0;
                    int xc = 0;
                    int ya = 0;
                    int yb = 0;
                    int yc = 0;
                    int za = 0;
                    int zb = 1;
                    int zc = 1;
                    int lvla = 0;
                    int lvlb = 0;
                    int lvlc = 0;
                    int cell_id = 0;
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    block41: for (int columnId = 1; columnId <= resultSetMetaData.getColumnCount(); ++columnId) {
                        switch (resultSetMetaData.getColumnLabel(columnId).toUpperCase()) {
                            case "XA": {
                                xa = columnId;
                                continue block41;
                            }
                            case "XB": {
                                xb = columnId;
                                continue block41;
                            }
                            case "XC": {
                                xc = columnId;
                                continue block41;
                            }
                            case "YA": {
                                ya = columnId;
                                continue block41;
                            }
                            case "YB": {
                                yb = columnId;
                                continue block41;
                            }
                            case "YC": {
                                yc = columnId;
                                continue block41;
                            }
                            case "ZA": {
                                za = columnId;
                                continue block41;
                            }
                            case "ZB": {
                                zb = columnId;
                                continue block41;
                            }
                            case "ZC": {
                                zc = columnId;
                                continue block41;
                            }
                            case "LVLA": {
                                lvla = columnId;
                                continue block41;
                            }
                            case "LVLB": {
                                lvlb = columnId;
                                continue block41;
                            }
                            case "LVLC": {
                                lvlc = columnId;
                                continue block41;
                            }
                            case "CELL_ID": {
                                cell_id = columnId;
                            }
                        }
                    }
                    if (xa == 0 || xb == 0 || xc == 0 || ya == 0 || yb == 0 || yc == 0 || za == 0 || zb == 0 || zc == 0 || lvla == 0 || lvlb == 0 || lvlc == 0 || cell_id == 0) {
                        throw new SQLException("Missing field in input tables");
                    }
                    while (rs.next()) {
                        int cellId = rs.getInt(cell_id);
                        if (cellId != lastCellId && lastCellId != -1) {
                            this.processCell(connection, cellId, polyMap, period, aggregateByPeriod);
                            polyMap.clear();
                        }
                        lastCellId = cellId;
                        Coordinate a = new Coordinate(rs.getDouble(xa), rs.getDouble(ya), rs.getDouble(za));
                        Coordinate b = new Coordinate(rs.getDouble(xb), rs.getDouble(yb), rs.getDouble(zb));
                        Coordinate c = new Coordinate(rs.getDouble(xc), rs.getDouble(yc), rs.getDouble(zc));
                        TriMarkers triMarkers = new TriMarkers(a, b, c, Utils.dbaToW((double)rs.getDouble(lvla)), Utils.dbaToW((double)rs.getDouble(lvlb)), Utils.dbaToW((double)rs.getDouble(lvlc)));
                        Map res = Contouring.processTriangle((TriMarkers)triMarkers, this.isoLevels);
                        for (Map.Entry entry : res.entrySet()) {
                            if (!polyMap.containsKey(entry.getKey())) {
                                polyMap.put((Short)entry.getKey(), new ArrayList());
                            }
                            ArrayList polygonsArray = (ArrayList)polyMap.get(entry.getKey());
                            for (TriMarkers tri : (Deque)entry.getValue()) {
                                Polygon poly = geometryFactory.createPolygon(new Coordinate[]{tri.p0, tri.p1, tri.p2, tri.p0});
                                polygonsArray.add(poly);
                            }
                        }
                    }
                }
                if (polyMap.isEmpty()) continue;
                this.processCell(connection, lastCellId, polyMap, period, aggregateByPeriod);
            }
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }
}

