/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.utils;

import java.util.ArrayList;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.math.Vector2D;

public class MakeParallelLines {
    public static LineString MakeParallelLine(LineString lineString, double distance) {
        Coordinate[] points = lineString.getCoordinates();
        if (points.length < 2) {
            return lineString.getFactory().createLineString();
        }
        ArrayList<Coordinate> newPoints = new ArrayList<Coordinate>(Math.max(10, points.length));
        newPoints.add(new LineSegment(points[0], points[1]).pointAlongOffset(0.0, distance));
        for (int i = 1; i < points.length - 1; ++i) {
            Coordinate a = points[i - 1];
            Coordinate b = points[i];
            Coordinate c = points[i + 1];
            if (Math.abs(Angle.angleBetween((Coordinate)a, (Coordinate)b, (Coordinate)c) - Math.PI) < 1.0E-12) {
                newPoints.add(new LineSegment(b, c).pointAlongOffset(0.0, distance));
                continue;
            }
            Coordinate p = Triangle.angleBisector((Coordinate)a, (Coordinate)b, (Coordinate)c);
            Vector2D bi = Vector2D.create((Coordinate)b, (Coordinate)p).normalize().multiply(distance);
            if (!Orientation.isCCW((Coordinate[])new Coordinate[]{a, b, c, a})) {
                bi = bi.multiply(-1.0);
            }
            Coordinate splitPt = Vector2D.create((Coordinate)b).add(bi).toCoordinate();
            newPoints.add(splitPt);
        }
        newPoints.add(new LineSegment(points[points.length - 2], points[points.length - 1]).pointAlongOffset(1.0, distance));
        return lineString.getFactory().createLineString(newPoints.toArray(new Coordinate[0]));
    }
}

