/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder;

import java.util.concurrent.Callable;
import org.h2gis.api.ProgressVisitor;
import org.noise_planet.noisemodelling.pathfinder.CutPlaneVisitor;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;

public final class ThreadPathFinder
implements Callable<Boolean> {
    int startReceiver;
    int endReceiver;
    PathFinder propagationProcess;
    ProgressVisitor visitor;
    CutPlaneVisitor dataOut;
    Scene data;

    public ThreadPathFinder(int startReceiver, int endReceiver, PathFinder propagationProcess, ProgressVisitor visitor, CutPlaneVisitor dataOut, Scene data) {
        this.startReceiver = startReceiver;
        this.endReceiver = endReceiver;
        this.propagationProcess = propagationProcess;
        this.visitor = visitor;
        this.dataOut = dataOut;
        this.data = data;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            for (int idReceiver = this.startReceiver; !(idReceiver >= this.endReceiver || this.visitor != null && this.visitor.isCanceled()); ++idReceiver) {
                long receiverPk = idReceiver;
                if (idReceiver < this.data.receiversPk.size()) {
                    receiverPk = this.data.receiversPk.get(idReceiver);
                }
                PathFinder.ReceiverPointInfo rcv = new PathFinder.ReceiverPointInfo(idReceiver, receiverPk, this.data.receivers.get(idReceiver));
                this.propagationProcess.computeRaysAtPosition(rcv, this.dataOut, this.visitor);
                if (this.visitor == null) continue;
                this.visitor.endStep();
            }
        }
        catch (Exception ex) {
            PathFinder.LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
            if (this.visitor != null) {
                this.visitor.cancel();
            }
            throw ex;
        }
        return true;
    }
}

