/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.prep.PreparedLineString;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.math.Vector2D;
import org.noise_planet.noisemodelling.pathfinder.PathFinder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;

public final class BuildingIntersectionPathVisitor
implements ItemVisitor {
    Set<Integer> itemProcessed = new HashSet<Integer>();
    Coordinate p1;
    Coordinate p2;
    boolean left;
    LineSegment p1Top2;
    PreparedLineString seg;
    Set<Integer> pushedBuildingsWideAnglePoints = new HashSet<Integer>();
    Set<Integer> pushedWallsPoints = new HashSet<Integer>();
    ProfileBuilder profileBuilder;
    Plane cutPlane;
    List<Coordinate> input;
    LineSegment intersectionLine = new LineSegment();
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public BuildingIntersectionPathVisitor(Coordinate p1, Coordinate p2, boolean left, ProfileBuilder profileBuilder, List<Coordinate> input, Plane cutPlane) {
        this.profileBuilder = profileBuilder;
        this.input = input;
        this.cutPlane = cutPlane;
        this.p1 = p1;
        this.p2 = p2;
        this.left = left;
        this.p1Top2 = new LineSegment(p1, p2);
        this.seg = new PreparedLineString((Lineal)GEOMETRY_FACTORY.createLineString(new Coordinate[]{p1, p2}));
    }

    public void setIntersectionLine(LineSegment segment) {
        this.intersectionLine = segment;
        this.itemProcessed.clear();
    }

    public void visitItem(Object item) {
        int id = (Integer)item;
        if (!this.itemProcessed.contains(id)) {
            this.itemProcessed.add(id);
            Wall processedWall = this.profileBuilder.getProcessedWalls().get(id);
            if (processedWall.getLineSegment().distance(this.intersectionLine) < 1.0E-7) {
                this.addItem(id);
            }
        }
    }

    public void addItem(int id) {
        Wall processedWall = this.profileBuilder.getProcessedWalls().get(id);
        if (processedWall.type == ProfileBuilder.IntersectionType.BUILDING) {
            if (this.pushedBuildingsWideAnglePoints.contains(processedWall.originId)) {
                return;
            }
            List<Coordinate> roofPoints = this.profileBuilder.getPrecomputedWideAnglePoints(processedWall.originId + 1);
            if (roofPoints == null) {
                return;
            }
            if (!(roofPoints = PathFinder.filterPointsBySide(this.p1Top2, this.left, PathFinder.cutRoofPointsWithPlane(this.cutPlane, roofPoints))).isEmpty()) {
                this.input.addAll(roofPoints);
                this.pushedBuildingsWideAnglePoints.add(processedWall.originId);
                throw new IllegalStateException();
            }
        } else if (processedWall.type == ProfileBuilder.IntersectionType.WALL) {
            if (this.pushedWallsPoints.contains(processedWall.originId)) {
                return;
            }
            Vector2D translationVector = new Vector2D(processedWall.p0, processedWall.p1).normalize().multiply(0.015);
            Coordinate extendedP0 = new Coordinate(processedWall.p0.x - translationVector.getX(), processedWall.p0.y - translationVector.getY(), processedWall.p0.z);
            Coordinate extendedP1 = new Coordinate(processedWall.p1.x + translationVector.getX(), processedWall.p1.y + translationVector.getY(), processedWall.p1.z);
            List<Coordinate> roofPoints = Arrays.asList(extendedP0, extendedP1);
            if (!(roofPoints = PathFinder.filterPointsBySide(this.p1Top2, this.left, PathFinder.cutRoofPointsWithPlane(this.cutPlane, roofPoints))).isEmpty()) {
                this.pushedWallsPoints.add(processedWall.originId);
                this.input.addAll(roofPoints);
                throw new IllegalStateException();
            }
        }
    }
}

