/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.locationtech.jts.geom.Coordinate;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointGroundEffect;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReflection;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointTopography;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointVEdgeDiffraction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointWall;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CutPointSource.class, name="Source"), @JsonSubTypes.Type(value=CutPointReceiver.class, name="Receiver"), @JsonSubTypes.Type(value=CutPointWall.class, name="Wall"), @JsonSubTypes.Type(value=CutPointReflection.class, name="Reflection"), @JsonSubTypes.Type(value=CutPointGroundEffect.class, name="GroundEffect"), @JsonSubTypes.Type(value=CutPointTopography.class, name="Topography"), @JsonSubTypes.Type(value=CutPointVEdgeDiffraction.class, name="VEdgeDiffraction")})
public abstract class CutPoint
implements Comparable<CutPoint> {
    public Coordinate coordinate = new Coordinate();
    public double zGround = Double.NaN;
    public double groundCoefficient = Double.NaN;

    public CutPoint() {
    }

    public CutPoint(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public CutPoint(Coordinate coordinate, double zGround, double groundCoefficient) {
        this.coordinate = coordinate;
        this.zGround = zGround;
        this.groundCoefficient = groundCoefficient;
    }

    public CutPoint(CutPoint other) {
        this.coordinate = other.coordinate.copy();
        this.zGround = other.zGround;
        this.groundCoefficient = other.groundCoefficient;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public void setGroundCoefficient(double groundCoefficient) {
        this.groundCoefficient = groundCoefficient;
    }

    public void setZGround(double zGround) {
        this.zGround = zGround;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public double getGroundCoefficient() {
        return this.groundCoefficient;
    }

    public Double getzGround() {
        return this.zGround;
    }

    @Override
    public int compareTo(CutPoint cutPoint) {
        return this.coordinate.compareTo(cutPoint.coordinate);
    }

    public String toString() {
        return "CutPoint{coordinate=" + this.coordinate + ", zGround=" + this.zGround + ", groundCoefficient=" + this.groundCoefficient + "}";
    }
}

