/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.LineSegment;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;

public class CutPointReflection
extends CutPoint {
    public LineSegment wall;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long wallPk = null;
    public List<Double> wallAlpha = Collections.emptyList();

    public CutPointReflection() {
    }

    public CutPointReflection(CutPoint cutPoint, LineSegment wall, List<Double> wallAlpha) {
        super(cutPoint);
        this.wall = wall;
        this.wallAlpha = wallAlpha;
    }

    public CutPointReflection setPk(long pk) {
        this.wallPk = pk;
        return this;
    }

    public double[] alphaAsArray() {
        return this.wallAlpha.stream().mapToDouble(aDouble -> aDouble).toArray();
    }

    public void setWallAlpha(List<Double> wallAlpha) {
        this.wallAlpha = wallAlpha;
    }

    @Override
    public String toString() {
        return "CutPointReflection{\nwall=" + this.wall + (String)(this.wallPk == null ? "" : "\n, wallPrimaryKey=" + this.wallPk) + "\n, wallAlpha=" + this.wallAlpha + "\n, coordinate=" + this.coordinate + "\n, zGround=" + this.zGround + "\n, groundCoefficient=" + this.groundCoefficient + "\n}";
    }
}

