/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;

public class CutPointWall
extends CutPoint {
    public LineSegment wall;
    public List<Double> wallAlpha = Collections.emptyList();
    @JsonIgnore
    public int processedWallIndex = -1;
    public INTERSECTION_TYPE intersectionType = INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long wallPk = null;

    public CutPointWall() {
    }

    public CutPointWall(int processedWallIndex, Coordinate intersection, LineSegment wallSegment, List<Double> wallAlpha) {
        this.wall = wallSegment;
        this.coordinate = intersection;
        this.processedWallIndex = processedWallIndex;
        this.wallAlpha = wallAlpha;
    }

    public CutPointWall setPk(long pk) {
        if (pk >= 0L) {
            this.wallPk = pk;
        }
        return this;
    }

    public double[] alphaAsArray() {
        return this.wallAlpha.stream().mapToDouble(aDouble -> aDouble).toArray();
    }

    @Override
    public String toString() {
        return "CutPointWall{groundCoefficient=" + this.groundCoefficient + ", zGround=" + this.zGround + ", coordinate=" + this.coordinate + ", processedWallIndex=" + this.processedWallIndex + ", wallAlpha=" + this.wallAlpha + ", wall=" + this.wall + "}";
    }

    public static enum INTERSECTION_TYPE {
        BUILDING_ENTER,
        BUILDING_EXIT,
        THIN_WALL_ENTER_EXIT;

    }
}

