/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;

public final class ElevationFilter
implements CoordinateSequenceFilter {
    AtomicBoolean geometryChanged = new AtomicBoolean(false);
    ProfileBuilder profileBuilder;
    boolean resetZ;
    AtomicInteger triangleHint = new AtomicInteger(-1);

    public ElevationFilter(ProfileBuilder profileBuilder, boolean resetZ) {
        this.profileBuilder = profileBuilder;
        this.resetZ = resetZ;
    }

    public void reset() {
        this.geometryChanged.set(false);
    }

    public void filter(CoordinateSequence coordinateSequence, int i) {
        Coordinate pt = coordinateSequence.getCoordinate(i);
        double zGround = this.profileBuilder.getZGround(pt, this.triangleHint);
        if (!Double.isNaN(zGround) && (this.resetZ || Double.isNaN(pt.getOrdinate(2)) || 0.0 == pt.getOrdinate(2))) {
            pt.setOrdinate(2, zGround + (Double.isNaN(pt.getOrdinate(2)) ? 0.0 : pt.getOrdinate(2)));
            this.geometryChanged.set(true);
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean isGeometryChanged() {
        return this.geometryChanged.get();
    }

    public static class UpdateZ
    implements CoordinateSequenceFilter {
        boolean done = false;
        final double z;

        public UpdateZ(double z) {
            this.z = z;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, 2, this.z);
            if (i == seq.size()) {
                this.done = true;
            }
        }
    }
}

