/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import java.util.ArrayList;
import java.util.List;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.WallAbsorption;

public class Obstruction {
    public static final double DEFAULT_G = 100000.0;
    private List<Double> alphas = new ArrayList<Double>();
    private double g = 100000.0;

    public void initialize(List<Double> frequencyExact) {
        if (this.alphas.size() != frequencyExact.size()) {
            this.alphas = new ArrayList<Double>();
            for (double freq : frequencyExact) {
                this.alphas.add(WallAbsorption.getWallAlpha(this.g, freq));
            }
        }
    }

    public void copyAlphas(Obstruction obstructionSource) {
        if (!obstructionSource.alphas.isEmpty()) {
            this.alphas = new ArrayList<Double>(obstructionSource.alphas);
        } else {
            this.alphas.clear();
        }
        this.g = obstructionSource.g;
    }

    public List<Double> getAlphas() {
        return this.alphas;
    }

    public double getG() {
        return this.g;
    }

    public void setG(double g) {
        this.g = g;
    }

    public void setAlpha(List<Double> alphas) {
        this.alphas = alphas;
    }
}

