/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils;

import java.util.Arrays;
import java.util.Locale;

public class AcousticIndicatorsFunctions {
    public static double dBToW(double dB) {
        return Math.pow(10.0, dB / 10.0);
    }

    public static double[] dBToW(double[] dB) {
        double[] ret = new double[dB.length];
        for (int i = 0; i < dB.length; ++i) {
            ret[i] = AcousticIndicatorsFunctions.dBToW(dB[i]);
        }
        return ret;
    }

    public static double wToDb(double w) {
        return 10.0 * Math.log10(w);
    }

    public static double[] wToDb(double[] w) {
        double[] ret = new double[w.length];
        for (int i = 0; i < w.length; ++i) {
            ret[i] = AcousticIndicatorsFunctions.wToDb(w[i]);
        }
        return ret;
    }

    public static double[] twoDgtAftrComma(double[] valeurs) {
        return Arrays.stream(valeurs).map(nombre -> Double.parseDouble(String.format(Locale.US, "%.2f", nombre))).toArray();
    }

    public static double[] sumArrayWithPonderation(double[] array1, double[] array2, double p) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Not same size array");
        }
        double[] sum = new double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            sum[i] = AcousticIndicatorsFunctions.wToDb(p * AcousticIndicatorsFunctions.dBToW(array1[i]) + (1.0 - p) * AcousticIndicatorsFunctions.dBToW(array2[i]));
        }
        return sum;
    }

    public static double[] sumDbArray(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Not same size array");
        }
        double[] sum = new double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            sum[i] = AcousticIndicatorsFunctions.wToDb(AcousticIndicatorsFunctions.dBToW(array1[i]) + AcousticIndicatorsFunctions.dBToW(array2[i]));
        }
        return sum;
    }

    public static double sumDbArray(double[] array1) {
        double sum = AcousticIndicatorsFunctions.dBToW(array1[0]);
        for (int i = 1; i < array1.length; ++i) {
            sum = AcousticIndicatorsFunctions.dBToW(array1[i]) + sum;
        }
        return AcousticIndicatorsFunctions.wToDb(sum);
    }

    public static double[] multiplicationArray(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("Not same size array");
        }
        double[] sum = new double[array1.length];
        for (int i = 0; i < array1.length; ++i) {
            sum[i] = array1[i] * array2[i];
        }
        return sum;
    }

    public static double[] multiplicationArray(double[] array, double coefficient) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * coefficient;
        }
        return result;
    }

    public static double sumArray(int nbfreq, double[] energeticSum) {
        double globlvl = 0.0;
        for (int idfreq = 0; idfreq < nbfreq; ++idfreq) {
            globlvl += energeticSum[idfreq];
        }
        return globlvl;
    }

    public static double sumArray(double[] energeticSum) {
        double globlvl = 0.0;
        for (int idfreq = 0; idfreq < energeticSum.length; ++idfreq) {
            globlvl += energeticSum[idfreq];
        }
        return globlvl;
    }

    public static double[] sumArray(double[] array1, double[] array2) {
        if (array1.length != array2.length) {
            if (array1.length == 0) {
                return array2;
            }
            if (array2.length == 0) {
                return array1;
            }
            throw new IllegalArgumentException("Arrays with different size");
        }
        double[] ret = new double[array1.length];
        for (int idfreq = 0; idfreq < array1.length; ++idfreq) {
            ret[idfreq] = array1[idfreq] + array2[idfreq];
        }
        return ret;
    }

    public static double[] sumArray(double[] array, double number) {
        double[] ret = new double[array.length];
        for (int idfreq = 0; idfreq < array.length; ++idfreq) {
            ret[idfreq] = array[idfreq] + number;
        }
        return ret;
    }

    public static Double[] asOctaveBands(Double[] thirdOctaveBands) {
        Double[] octaveBands = new Double[thirdOctaveBands.length / 3];
        int j = 0;
        for (int i = 1; i < thirdOctaveBands.length - 1; i += 3) {
            octaveBands[j++] = thirdOctaveBands[i];
        }
        return octaveBands;
    }

    public static Integer[] asOctaveBands(Integer[] thirdOctaveBands) {
        Integer[] octaveBands = new Integer[thirdOctaveBands.length / 3];
        int j = 0;
        for (int i = 1; i < thirdOctaveBands.length - 1; i += 3) {
            octaveBands[j++] = thirdOctaveBands[i];
        }
        return octaveBands;
    }

    public static Integer[] asOctaveBands(int[] thirdOctaveBands) {
        Integer[] octaveBands = new Integer[thirdOctaveBands.length / 3];
        int j = 0;
        for (int i = 1; i < thirdOctaveBands.length - 1; i += 3) {
            octaveBands[j++] = thirdOctaveBands[i];
        }
        return octaveBands;
    }
}

