/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils;

public class ComplexNumber {
    public static final int XY = 0;
    public static final int RCIS = 1;
    private double real;
    private double imaginary;

    public ComplexNumber() {
        this.real = 0.0;
        this.imaginary = 0.0;
    }

    public ComplexNumber(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    public void add(ComplexNumber z) {
        this.set(ComplexNumber.add(this, z));
    }

    public void subtract(ComplexNumber z) {
        this.set(ComplexNumber.subtract(this, z));
    }

    public void multiply(ComplexNumber z) {
        this.set(ComplexNumber.multiply(this, z));
    }

    public void divide(ComplexNumber z) {
        this.set(ComplexNumber.divide(this, z));
    }

    public void set(ComplexNumber z) {
        this.real = z.real;
        this.imaginary = z.imaginary;
    }

    public static ComplexNumber add(ComplexNumber z1, ComplexNumber z2) {
        return new ComplexNumber(z1.real + z2.real, z1.imaginary + z2.imaginary);
    }

    public static ComplexNumber subtract(ComplexNumber z1, ComplexNumber z2) {
        return new ComplexNumber(z1.real - z2.real, z1.imaginary - z2.imaginary);
    }

    public static ComplexNumber multiply(ComplexNumber z1, ComplexNumber z2) {
        double _real = z1.real * z2.real - z1.imaginary * z2.imaginary;
        double _imaginary = z1.real * z2.imaginary + z1.imaginary * z2.real;
        return new ComplexNumber(_real, _imaginary);
    }

    public static ComplexNumber divide(ComplexNumber z1, ComplexNumber z2) {
        ComplexNumber output = ComplexNumber.multiply(z1, z2.conjugate());
        double div = Math.pow(z2.mod(), 2.0);
        return new ComplexNumber(output.real / div, output.imaginary / div);
    }

    public ComplexNumber conjugate() {
        return new ComplexNumber(this.real, -this.imaginary);
    }

    public double mod() {
        return Math.sqrt(Math.pow(this.real, 2.0) + Math.pow(this.imaginary, 2.0));
    }

    public ComplexNumber square() {
        double _real = this.real * this.real - this.imaginary * this.imaginary;
        double _imaginary = 2.0 * this.real * this.imaginary;
        return new ComplexNumber(_real, _imaginary);
    }

    public String toString() {
        String re = "" + this.real;
        Object im = "";
        im = this.imaginary < 0.0 ? this.imaginary + "i" : "+" + this.imaginary + "i";
        return re + (String)im;
    }

    public static ComplexNumber exp(ComplexNumber z) {
        double a = z.real;
        double b = z.imaginary;
        double r = Math.exp(a);
        a = r * Math.cos(b);
        b = r * Math.sin(b);
        return new ComplexNumber(a, b);
    }

    public static ComplexNumber pow(ComplexNumber z, int power) {
        ComplexNumber output = new ComplexNumber(z.getRe(), z.getIm());
        for (int i = 1; i < power; ++i) {
            double _real = output.real * z.real - output.imaginary * z.imaginary;
            double _imaginary = output.real * z.imaginary + output.imaginary * z.real;
            output = new ComplexNumber(_real, _imaginary);
        }
        return output;
    }

    public static ComplexNumber sin(ComplexNumber z) {
        double x = Math.exp(z.imaginary);
        double x_inv = 1.0 / x;
        double r = Math.sin(z.real) * (x + x_inv) / 2.0;
        double i = Math.cos(z.real) * (x - x_inv) / 2.0;
        return new ComplexNumber(r, i);
    }

    public static ComplexNumber cos(ComplexNumber z) {
        double x = Math.exp(z.imaginary);
        double x_inv = 1.0 / x;
        double r = Math.cos(z.real) * (x + x_inv) / 2.0;
        double i = -Math.sin(z.real) * (x - x_inv) / 2.0;
        return new ComplexNumber(r, i);
    }

    public static ComplexNumber tan(ComplexNumber z) {
        return ComplexNumber.divide(ComplexNumber.sin(z), ComplexNumber.cos(z));
    }

    public static ComplexNumber cot(ComplexNumber z) {
        return ComplexNumber.divide(new ComplexNumber(1.0, 0.0), ComplexNumber.tan(z));
    }

    public static ComplexNumber sec(ComplexNumber z) {
        return ComplexNumber.divide(new ComplexNumber(1.0, 0.0), ComplexNumber.cos(z));
    }

    public static ComplexNumber cosec(ComplexNumber z) {
        return ComplexNumber.divide(new ComplexNumber(1.0, 0.0), ComplexNumber.sin(z));
    }

    public double getRe() {
        return this.real;
    }

    public double getIm() {
        return this.imaginary;
    }

    public double getArg() {
        return Math.atan2(this.imaginary, this.real);
    }

    public static ComplexNumber parseComplex(String s) {
        s = s.replaceAll(" ", "");
        ComplexNumber parsed = null;
        if (s.contains(String.valueOf("+")) || s.contains(String.valueOf("-")) && s.lastIndexOf(45) > 0) {
            String re = "";
            String im = "";
            s = s.replaceAll("i", "");
            if ((s = s.replaceAll("I", "")).indexOf(43) > 0) {
                re = s.substring(0, s.indexOf(43));
                im = s.substring(s.indexOf(43) + 1, s.length());
                parsed = new ComplexNumber(Double.parseDouble(re), Double.parseDouble(im));
            } else if (s.lastIndexOf(45) > 0) {
                re = s.substring(0, s.lastIndexOf(45));
                im = s.substring(s.lastIndexOf(45) + 1, s.length());
                parsed = new ComplexNumber(Double.parseDouble(re), -Double.parseDouble(im));
            }
        } else if (s.endsWith("i") || s.endsWith("I")) {
            s = s.replaceAll("i", "");
            s = s.replaceAll("I", "");
            parsed = new ComplexNumber(0.0, Double.parseDouble(s));
        } else {
            parsed = new ComplexNumber(Double.parseDouble(s), 0.0);
        }
        return parsed;
    }

    public final boolean equals(Object z) {
        if (!(z instanceof ComplexNumber)) {
            return false;
        }
        ComplexNumber a = (ComplexNumber)z;
        return this.real == a.real && this.imaginary == a.imaginary;
    }

    public ComplexNumber inverse() {
        return ComplexNumber.divide(new ComplexNumber(1.0, 0.0), this);
    }

    public String format(int format_id) throws IllegalArgumentException {
        Object out = "";
        if (format_id == 0) {
            out = this.toString();
        } else if (format_id == 1) {
            out = this.mod() + " cis(" + this.getArg() + ")";
        } else {
            throw new IllegalArgumentException("Unknown Complex Number format.");
        }
        return out;
    }
}

