/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.documents;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryManager;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.noise_planet.noisemodelling.pathfinder.delaunay.Triangle;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.documents.KMLDocument;

public class GeoJSONDocument {
    public JsonGenerator jsonGenerator;
    public String crs = "EPSG:4326";
    public int rounding = -1;
    public CoordinateOperation transform = null;

    public GeoJSONDocument(OutputStream outputStream) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        this.jsonGenerator = jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        this.jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter("\n"));
    }

    public void doTransform(Geometry geometry) {
        if (this.transform != null && geometry != null) {
            geometry.apply((CoordinateFilter)new KMLDocument.CRSTransformFilter(this.transform));
            geometry.setSRID(4326);
        }
    }

    public void setInputCRS(String crs) throws CRSException, CoordinateOperationException {
        CRSFactory cRSFactory = new CRSFactory();
        RegistryManager registryManager = cRSFactory.getRegistryManager();
        registryManager.addRegistry((Registry)new EPSGRegistry());
        CoordinateReferenceSystem crsKML = cRSFactory.getCRS("EPSG:4326");
        CoordinateReferenceSystem crsSource = cRSFactory.getCRS(crs);
        if (crsKML instanceof GeodeticCRS && crsSource instanceof GeodeticCRS) {
            this.transform = (CoordinateOperation)CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)crsSource), (GeodeticCRS)((GeodeticCRS)crsKML)).iterator().next();
        }
    }

    public void setRounding(int rounding) {
        this.rounding = rounding;
    }

    public void writeFooter() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeObjectFieldStart("crs");
        this.jsonGenerator.writeStringField("type", "name");
        this.jsonGenerator.writeObjectFieldStart("properties");
        this.jsonGenerator.writeStringField("name", this.crs);
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
    }

    public void writeHeader() throws IOException {
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeStringField("type", "FeatureCollection");
        this.jsonGenerator.writeArrayFieldStart("features");
    }

    public void writeProfile(CutProfile profile) throws IOException {
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeStringField("type", "Feature");
        this.jsonGenerator.writeObjectFieldStart("geometry");
        this.jsonGenerator.writeStringField("type", "LineString");
        this.jsonGenerator.writeFieldName("coordinates");
        this.jsonGenerator.writeStartArray();
        for (CutPoint cutPoint : profile.cutPoints) {
            this.writeCoordinate(new Coordinate(cutPoint.getCoordinate()));
        }
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeObjectFieldStart("properties");
        this.jsonGenerator.writeNumberField("receiver", profile.getReceiver().receiverPk);
        this.jsonGenerator.writeNumberField("source", profile.getSource().sourcePk);
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeEndObject();
    }

    public void writeCutPoint(CutPoint cutPoint) throws IOException {
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeStringField("type", "Feature");
        this.jsonGenerator.writeObjectFieldStart("geometry");
        this.jsonGenerator.writeStringField("type", "Point");
        this.jsonGenerator.writeFieldName("coordinates");
        this.writeCoordinate(new Coordinate(cutPoint.getCoordinate()));
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeObjectFieldStart("properties");
        this.jsonGenerator.writeObject((Object)cutPoint);
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
    }

    public void writeTopographic(List<Triangle> triVertices, List<Coordinate> vertices) throws IOException {
        for (Triangle triangle : triVertices) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("type", "Feature");
            this.jsonGenerator.writeObjectFieldStart("geometry");
            this.jsonGenerator.writeStringField("type", "Polygon");
            this.jsonGenerator.writeFieldName("coordinates");
            this.jsonGenerator.writeStartArray();
            this.jsonGenerator.writeStartArray();
            this.writeCoordinate(new Coordinate(vertices.get(triangle.getA())));
            this.writeCoordinate(new Coordinate(vertices.get(triangle.getB())));
            this.writeCoordinate(new Coordinate(vertices.get(triangle.getC())));
            this.writeCoordinate(new Coordinate(vertices.get(triangle.getA())));
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeObjectFieldStart("properties");
            this.jsonGenerator.writeNumberField("b", triangle.getAttribute());
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
        }
    }

    public void writeCoordinate(Coordinate coordinate) throws IOException {
        this.jsonGenerator.writeStartArray();
        if (this.transform != null) {
            try {
                double[] coords = this.transform.transform(new double[]{coordinate.x, coordinate.y});
                coordinate = new Coordinate(coords[0], coords[1], coordinate.z);
            }
            catch (IllegalCoordinateException | CoordinateOperationException ex) {
                throw new IOException("Error while doing transform", ex);
            }
        }
        this.writeNumber(coordinate.x);
        this.writeNumber(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            this.writeNumber(coordinate.z);
        }
        this.jsonGenerator.writeEndArray();
    }

    public void writeNumber(double number) throws IOException {
        if (this.rounding >= 0) {
            this.jsonGenerator.writeNumber(String.format(Locale.ROOT, "%." + this.rounding + "f", number));
        } else {
            this.jsonGenerator.writeNumber(number);
        }
    }
}

